const express = require('express');
const app = express();
var http = require('http').Server(app);
var io = require('socket.io')(http);

var clients = [];

io.on('connection', socket => {
    // registrar un nuevo usuario en la lista 
    // de nuevas conexiones 
    socket.on('register', user => {
            
            clients.push({
                socketId: socket.id,
                socket: user
            });

            console.log(clients)
            io.emit('notificacion', user);
    });
  
    // emitir nuevas notificaciones a un socket especifico
    socket.on('nuevoDocumento', msg => {
        console.log(msg)
        // io.sockets.emit('nuevoDocumento', msg);
        clients.map(client => {
            let count = 0;
            // io.to(client.socketId).emit('escucharnotificacion', msg);
            msg.map(mensaje => {
                if(client.socket == mensaje.to){
                    count++;
                    // Enviar info a todos los sockets
                    // io.emit('message', msg);
                    // Enviar info a un socket especifico
                    // console.log('emitido a:', client.socket)
                   
                    // console.log('notificado')
                }                
            });
            io.to(client.socketId).emit('nuevoDocumento', count);
        });
    });

    socket.on('documentoRevisado', to => {
        // io.sockets.emit('nuevoDocumento', msg);
        clients.map(client => {
            if(client.socket == to){
                io.to(client.socketId).emit('documentoRevisado', 1);
            } 
        });
    });

    socket.on('disconnect', () => {
        //   console.log(socket.id+' user disconnected');
        console.log("================================")
        console.log(clients);
    });
    
    socket.on('logout', user => {
        // console.log('logout', user);
        console.log(clients.length);
        eliminar(user);
        console.log(clients);
    });

    eliminar = user =>{
        let value = true;
        while(value){
            clients.splice( clients.indexOf(user), 1 );
            console.log(clients.length);
            value = (clients.indexOf(user) >= 0)?true:false;
        };
    }
});

//Settings
app.set('port', process.env.PORT || 3000);

//Start the Server
http.listen(app.get('port'), () => {
    console.log('Server on port', app.get('port'));
});