var servicesModule = angular.module('PavitaServices');
var baseUrl2='https://mevi.sigadh.com/api';
// var baseUrl2='http://127.0.0.1:8000';
let token=localStorage.getItem("satellizer_token");

servicesModule.factory('reportService', ['$http', ( $http ) => {
        return {
            api: () => {
                return baseUrl2;
            },
            login: ( data ) => {
                return $http.post(baseUrl2+'/api/autenticate/login', { ...data });
            },
            obtenerDepartamentos: ( tipo='producto' ) => {
                return $http.get(baseUrl2+'/api/departamentos/'+tipo);
            },
            obtenerCategorias: ( ) => {
                return $http.get(baseUrl2+'/api/categorias');
            },
            obtenerUnidades: ( ) => {
                return $http.get(baseUrl2+'/api/unidades', { token });
            },
            registrarme: ( data ) => {
                return $http.post(baseUrl2+'/api/autenticate/registro', { ...data });
            },
            obtenerMisProductos: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/productos/mis-productos?page='+pagina, { token });
            },
            obtenerProducto: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/productos/'+id_producto);
            },
            obtenerProductos: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/productos?page='+pagina);
            },
            realizarOferta: ( data ) => {
                return $http.post(baseUrl2+'/api/ofertas/nueva', { ...data });
            },
            obtenerInformacionVendedor: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/ofertas/informacion-vendedor/'+id_producto);
            },
            obtenerOfertas: ( oferta = 'productos' ) => {
                if( oferta == 'productos' )
                    return $http.get(baseUrl2+'/api/ofertas', { token });
                else if( oferta == 'proveedores' )
                    return $http.get(baseUrl2+'/api/proveedores/ofertas', { token });
                else if( oferta == 'inclusion' )
                    return $http.get(baseUrl2+'/api/inclusionProductiva/ofertas', { token });
            },
            obtenerOfertasProducto: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/ofertas/producto', { token, params : { id_producto } });
            },
            enviarOfertaActualizada: ( data ) => {
                return $http.post(baseUrl2+'/api/ofertas/actualizar', { token, ...data });
            },
            obtenerNumeroOfertas: ( ) => {
                return $http.get(baseUrl2+'/api/ofertas/total', { token });
            },
            filtrarProductosPublicos: ( data, pagina = 1 ) => {
                return $http.post(baseUrl2+'/api/filtros/publicos?page='+pagina, { ...data });
            },
            filtrarProductosPrivados: ( data, pagina = 1 ) => {
                return $http.post(baseUrl2+'/api/filtros/privados?page='+pagina, { ...data });
            },
            obtenerMiInformacion: ( ) => {
                return $http.get(baseUrl2+'/api/usuario', { token });
            },
            actualizarMiInformacion: ( data ) => {
                return $http.post(baseUrl2+'/api/usuario/actualizacion', { token, ...data });
            },
            actualizarProducto: ( data ) => {
                return $http.post(baseUrl2+'/api/productos/actualizar', { ...data });
            },
            consultarMisOfertas: ( ) => {
                return $http.get(baseUrl2+'/api/ofertas/realizadas', { token });
            },
            respuestaOfertas: ( ) => {
                return $http.get(baseUrl2+'/api/ofertas/respuestas', { token });
            },
            visadoNotificacionInteres: ( id ) => {
                return $http.post(baseUrl2+'/api/ofertas/visado', { token, id });
            },
            obtenerUbicaciones: ( ) => {
                return $http.get(baseUrl2+'/api/ubicaciones', { token });
            },
            obtenerUbicacionesVentas: ( ) => {
                return $http.get(baseUrl2+'/api/ubicaciones/ventas', { token });
            },
            obtenerUbicacionesRecibidos: ( ) => {
                return $http.get(baseUrl2+'/api/ubicaciones/recibidos', { token });
            },
            actualizarOfertaCompraRecibida: ( data ) => {
                return $http.post(baseUrl2+'/api/ofertas/compra-recibida', { token, ...data });
            },
            obtenerUnidades: ( ) => {
                return $http.get(baseUrl2+'/api/unidades', { token });
            },
            registrarUnidad: ( data ) => {
                return $http.post(baseUrl2+'/api/unidades/nueva', { token, ...data });
            },
            editarUnidad: ( data ) => {
                return $http.post(baseUrl2+'/api/unidades', { token, ...data });
            },
            obtenerCategorias: ( ) => {
                return $http.get(baseUrl2+'/api/categorias', { token });
            },
            registrarCategoria: ( data ) => {
                return $http.post(baseUrl2+'/api/categorias/nueva', { token, ...data });
            },
            editarCategoria: ( data ) => {
                return $http.post(baseUrl2+'/api/categorias', { token, ...data });
            },
            obtenerTipoProductos: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/tipo-productos?page='+pagina, { token });
            },
            obtenerProveedores: ( pagina = 1 ) => {
                if(token != null)
                    return $http.get(baseUrl2+'/api/proveedores?page='+pagina, { token });
                else
                    return $http.get(baseUrl2+'/api/proveedores/publicos?page='+pagina);
            },
            obtenerCategoriasProveedores: ( id_proveedor ) => {
                if(token != null)
                    return $http.get(baseUrl2+'/api/proveedores/categorias/privado', { token, params: { id_proveedor } });
                else
                    return $http.get(baseUrl2+'/api/proveedores/categorias');
            },
            obtenerCategoriasProveedoresAdministrador: ( ) => {
                    return $http.get(baseUrl2+'/api/proveedores/categorias/listadoAdministrador', { token });
            },
            registrarCategoriaProveedores: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/categorias/nueva', { token, ...data });
            },
            editarCategoriaProveedor: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/categorias', { token, ...data });
            },
            obtenerTipoProductosProveedores: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/proveedores/tipo-productos?page='+pagina, { token });
            },
            obtenerProductosProveedorActual: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/proveedores/productos/mis-productos?page='+pagina);
            },
            obtenerProductosProveedor: ( proveedor, pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/proveedores/productos/'+proveedor+'?page='+pagina);
            },
            agregarAlCarrito: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/carrito/nuevo', { token, ...data });
            },
            obtenerCarritos: ( ) => {
                return $http.get(baseUrl2+'/api/proveedores/carrito', { token });
            },
            actualizarProdructoCarrito: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/carrito/actualizar', { token, ...data });
            },
            eliminarProdructoCarrito: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/carrito/eliminar', { token, ...data });
            },
            realizarIntencionesProveedor: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/ofertas/nueva', { token, ...data });
            },
            informacionCarrito: ( id ) => {
                return $http.get(baseUrl2+'/api/proveedores/carrito/'+id, { token });
            },
            consultarMisOfertasProveedores: ( ) => {
                return $http.get(baseUrl2+'/api/proveedores/carrito/enviados', { token });
            },
            obtenerOfertasProveedor: ( id_carrito ) => {
                return $http.get(baseUrl2+'/api/proveedores/ofertas/productos', { token, params: { id_carrito } });
            },
            enviarOfertaProveedorActualizada: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/ofertas/actualizar', { token, ...data });
            },
            filtrarProveedores: ( data, pagina = 1 ) => {
                if(token != null)
                    return $http.post(baseUrl2+'/api/filtros/proveedores/privados?page='+pagina, { ...data });
                else if(token == null)
                    return $http.post(baseUrl2+'/api/filtros/proveedores/publicos?page='+pagina, { ...data });
            },
            filtrarProductosProveedores: ( data, pagina = 1 ) => {
                return $http.post(baseUrl2+'/api/filtros/proveedores/productos?page='+pagina, { ...data });
            },
            notificacionesCarrito: (  ) => {
                return $http.get(baseUrl2+'/api/proveedores/carrito/notificaciones', { token });
            },
            obtenerNumeroOfertasProveedor: ( ) => {
                return $http.get(baseUrl2+'/api/proveedores/ofertas/total', { token });
            },
            obtenerListadoProveedorActual: ( ) => {
                return $http.get(baseUrl2+'/api/proveedores/listado', { token });
            },
            cambiarPasswordProveedor: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/cambiarPassword', { token, ...data });
            },
            actualizarProducto: ( data ) => {
                return $http.post(baseUrl2+'/api/proveedores/stock/nuevo', { token, ...data });
            },



            obtenerCategoriasInclusionProductiva: ( ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/categorias');
            },
            obtenerProductoInclusionProductiva: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/productos/'+id_producto);
            },
            obtenerProductosInclusionProductiva: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/productos?page='+pagina);
            },
            filtrarProductosPublicosInclusionProductiva: ( data, pagina = 1 ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/filtros/publicos?page='+pagina, { ...data });
            },
            actualizarProductoInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/productos/actualizar', { ...data });
            },
            obtenerMisProductosInclusionProductiva: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/productos/mis-productos?page='+pagina, { token });
            },
            filtrarProductosPrivadosInclusionProductiva: ( data, pagina = 1 ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/filtros/privados?page='+pagina, { ...data, token });
            },
            actualizarProductoInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/productos/actualizar', { ...data, token });
            },
            realizarOfertaInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/ofertas/nueva', { ...data });
            },
            obtenerInformacionVendedorInclusionProductiva: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/ofertas/informacion-vendedor/'+id_producto);
            },
            consultarMisOfertasInclusionProductiva: ( ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/ofertas/realizadas', { token });
            },
            actualizarOfertaCompraRecibidaInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/ofertas/compra-recibida', { token, ...data });
            },
            obtenerOfertasProductoInclusionProductiva: ( id_producto ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/ofertas/producto', { token, params : { id_producto } });
            },
            enviarOfertaActualizadaInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/ofertas/actualizar', { token, ...data });
            },
            visadoNotificacionInteresInclusionProductiva: ( id ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/ofertas/visado', { token, id });
            },

            obtenerSesiones: ( token_value ) => {
                if( token_value == null ){
                    return $http.get(baseUrl2+'/api/inclusionProductiva/sesiones/publicas');
                }else{
                    return $http.get(baseUrl2+'/api/inclusionProductiva/sesiones', { token });
                }
            },
            crearSesion: ( sesion ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/sesiones/nueva', { token, ...sesion });
            },
            editarSesion: ( sesion ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/sesiones', { token, ...sesion });
            },
            eliminarSesion: ( id ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/sesiones/eliminar', { token, id });
            },

            obtenerCategoriasInclusionProductiva: ( ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/categorias');
            },
            registrarCategoriaInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/categorias/nueva', { token, ...data });
            },
            editarCategoriaInclusionProductiva: ( data ) => {
                return $http.post(baseUrl2+'/api/inclusionProductiva/categorias', { token, ...data });
            },
            obtenerTipoProductosInclusionProductiva: ( pagina = 1 ) => {
                return $http.get(baseUrl2+'/api/inclusionProductiva/tipo-productos?page='+pagina, { token });
            },
            organizaciones: ( ) => {
                return $http.get('http://movil.monitoreo.sigadh.com/select/organizaciones');
            },


        };
    }]);