var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoUnidadesController',
    function ($scope, $rootScope, socketService, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.unidades = [];

        const socket = socketService.io();

        $scope.unidadesMedida = () => {
            reportService.obtenerUnidades(  ).then( ( { data } ) => {
                $scope.unidades = data;
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.unidadesMedida();

        $scope.nuevaUnidad = () => {
            reportService.registrarUnidad( { nombre: $scope.unidad } ).then( ( { data } ) => {
                alert('Unidad de medida registrada correctamente.');
                $scope.unidades = data;
                $scope.unidad = '';
            }, ( error ) => {
                if(error.status == 422){
                    alert('El nombre es obligatorio');
                }
            });
        }

        $scope.editarUnidad = ({ unidad }) => {
            let unidad_modificada = prompt("Ingrese la unidad de medida.");
            
            if ( unidad_modificada != null ) {
                let data = {
                    ...unidad,
                    unidad_modificada
                }
            
                reportService.editarUnidad( data ).then( ( { data } ) => {
                    alert('Unidad de medida modificada correctamente.');
                    $scope.unidades = data;
                }, ( error ) => {
                    if(error.status == 422){
                        alert('El nombre es obligatorio');
                    }
                });
            }

        }

 

});
