var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoUbicacionesController',
    function ($scope, reportService,userService, socketService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        const socket = socketService.io();

        $scope.path = window.location.pathname;

        console.log($scope.path)

        reportService.obtenerCategorias(  ).then( ( { data } ) => {
            $scope.categorias = data;
        }, ( error ) => {
            // if(error.status == 401){
            //     authService.logout();
            // }
        });

        /**
         * Obtiene las ubicaciones al cargar la vista
         */

        $scope.buscarUbicaciones = () => {
            reportService.obtenerUbicaciones(  ).then( ( { data } ) => {
                $scope.totalProductos = data.length;
                $scope.listadoProductos = data;
                $scope.map.markers = data;
    
            }, ( error ) => {
                if(error.status == 401){
                    // authService.logout();
                }
            });
        }

        $scope.buscarUbicacionesVentas = () => {
            reportService.obtenerUbicacionesVentas(  ).then( ( { data } ) => {
                console.log(data)
                $scope.totalProductos = data.length;
                $scope.listadoProductos = data;
                $scope.map.markers = data;
    
            }, ( error ) => {
                console.log(error)
                if(error.status == 401){
                    // authService.logout();
                }
            });
        }

        $scope.buscarUbicacionesRecibidos = () => {
            reportService.obtenerUbicacionesRecibidos(  ).then( ( { data } ) => {
                console.log(data)
                $scope.totalProductos = data.length;
                $scope.listadoProductos = data;
                $scope.map.markers = data;
    
            }, ( error ) => {
                console.log(error)
                if(error.status == 401){
                    // authService.logout();
                }
            });
        }

        if( $scope.path == '/ubicaciones' ){
            $scope.buscarUbicaciones();
        }else if( $scope.path == '/ventas' ){
            $scope.buscarUbicacionesVentas();
        }else if( $scope.path == '/ventas-recibidas' ){
            $scope.buscarUbicacionesRecibidos();
        }

        /**
         * Actualiza en tiempo real las ubicaciones, cada vez que se registra un nuevo producto
         */
        socket.on("mostrarNuevosProductos", function (data) {
            if( $scope.path == '/ubicaciones' ){
                $scope.buscarUbicaciones();
            }else if( $scope.path == '/ventas' ){
    
            }else if( $scope.path == '/ventas-recibidas' ){
    
            }
        });


        $scope.map={
            center: {latitude: 9.141107, longitude: -74.974835},
            zoom:   8,
            window: {
                model: {},
                show: false
            },
            options: {mapTypeId: google.maps.MapTypeId.HYBRID, withCredentials: true},
            markers: [],
            markersEvents: {
                click: function(marker, eventName, model, args) {

                    $scope.map.window.model = model;
                    // console.log($scope.map.window.model)
                    
                    if( $scope.path == '/ubicaciones' ){
                        $scope.map.window.show = true;  
                    }else if( $scope.path == '/ventas' ){
                        $('#modal_venta').modal('show');
                    }else if( $scope.path == '/ventas-recibidas' ){
                        $('#modal_venta').modal('show');
                    }
                    
                }
            }
        };

        $scope.filtrarProductos = () => {
            let productos = [];

            if( $scope.path == '/ubicaciones' ){
                if( $scope.id_categoria == '' ){
                    $scope.map.markers = $scope.listadoProductos;
                }else{
                    $scope.listadoProductos.map( producto => {
                        if(producto.tipo_producto.categoria.id == $scope.id_categoria){
                            productos = [
                                ...productos,
                                producto
                            ]
                        }
                    } )
    
                    $scope.map.markers = productos;
                }
            }else if( $scope.path == '/ventas' || $scope.path == '/ventas-recibidas' ){
                if( $scope.id_categoria == '' ){
                    $scope.map.markers = $scope.listadoProductos;
                }else{
                    $scope.listadoProductos.map( producto => {
                        if(producto.producto.tipo_producto.categoria.id == $scope.id_categoria){
                            productos = [
                                ...productos,
                                producto
                            ]
                        }
                    } )
    
                    $scope.map.markers = productos;
                }
    
            }
        }
       
});