var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoTipoProductosController',
    function ($scope, $rootScope, socketService, Upload, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.tipo_productos = [];
        $scope.categoria = '';

        $scope.actualizar = false;

        $scope.token=localStorage.getItem("satellizer_token");

        const socket = socketService.io();

        $scope.tipoProductos = () => {
            reportService.obtenerTipoProductos(  ).then( ( { data } ) => {
                $scope.tipo_productos = data.data;

                $scope.pages = [];

                if( data.last_page < 8 ){
                    for (let i = 1; i <= data.last_page; i++) {
                        $scope.pages.push(i)
                    }
                }else{
                    for (let i = 1; i <= 8; i++) {
                        if(i==7){
                            $scope.pages.push('...')
                        }else if(i === 8){
                            $scope.pages.push(data.last_page)
                        }else{
                            $scope.pages.push(i)
                        }
                    }
                }

                $scope.path = data.path;
                $scope.last_page = data.last_page;
                $scope.current_page = 1;
                $scope.total_productos = data.total;

            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.tipoProductos();


        $scope.categorias = () => {
            reportService.obtenerCategorias(  ).then( ( { data } ) => {
                $scope.categorias = data;
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.categorias();

        $scope.unidades = () => {
            reportService.obtenerUnidades(  ).then( ( { data } ) => {
                $scope.unidades = data;
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.unidades();

        // Paginación
        $scope.setCurrent = ( pagina, indice = -1 ) => {
            $scope.current_page = pagina;
            let indice_actual = indice;

            // Comportamiento botones de paginación
            if( $scope.last_page >= 8 ){
                if( indice === -1 ){
                    $scope.pages.map( ( p, index ) => {
                        if( p === pagina ){
                            indice_actual = index
                        }
                    } );
                    
                }

                const bandera = $scope.pages[indice_actual]; // valor de la pagina seleccionada

                if( bandera === $scope.last_page ){
                    $scope.pages[1] = '...';
                    $scope.pages[indice_actual - 1] = bandera - 1;
                    $scope.pages[indice_actual - 2] = bandera - 2;
                    $scope.pages[indice_actual - 3] = bandera - 3;
                    $scope.pages[indice_actual - 4] = bandera - 4;
                    $scope.pages[indice_actual - 5] = bandera - 5;
                }else if( bandera === 1 ){
                    $scope.pages[6] = '...';
                    $scope.pages[indice_actual + 1] = bandera + 1;
                    $scope.pages[indice_actual + 2] = bandera + 2;
                    $scope.pages[indice_actual + 3] = bandera + 3;
                    $scope.pages[indice_actual + 4] = bandera + 4;
                    $scope.pages[indice_actual + 5] = bandera + 5;
                }else{
                    if($scope.pages[indice_actual + 1] === '...'){
                        // Valida el comportamiento ascendente de la paginación
                        $scope.pages[1] = '...';

                        if( pagina + 3 === $scope.last_page ){
                            $scope.pages[indice_actual + 2] = bandera + 3;
                            $scope.pages[indice_actual + 1] = bandera + 2;
                            $scope.pages[indice_actual] = bandera + 1;
                            $scope.pages[indice_actual - 1] = bandera;
                        }else if( pagina + 2 === $scope.last_page ){
                            $scope.pages[indice_actual + 1] = bandera + 1;
                        }else{
                            $scope.pages[indice_actual] = bandera + 1;
                            $scope.pages[indice_actual - 1] = bandera;
                            $scope.pages[indice_actual - 2] = bandera - 1;
                            $scope.pages[indice_actual - 3] = bandera - 2;
                        }

                    }else if($scope.pages[indice_actual - 1] === '...'){
                        // Valida el comportamiento descendente de la paginación
                        $scope.pages[6] = '...';

                        if( pagina - 3 === 1 ){
                            $scope.pages[indice_actual - 2] = bandera - 3;
                            $scope.pages[indice_actual - 1] = bandera - 2;
                            $scope.pages[indice_actual] = bandera - 1;
                            $scope.pages[indice_actual + 1] = bandera;
                        }else if( pagina - 2 === 1 ){
                            $scope.pages[indice_actual - 1] = bandera - 1;
                        }else{
                            $scope.pages[indice_actual] = bandera - 1;
                            $scope.pages[indice_actual + 1] = bandera;
                            $scope.pages[indice_actual + 2] = bandera + 1;
                            $scope.pages[indice_actual + 3] = bandera + 2;
                        }
    
                    }
                }

            }

            // if( $scope.filtroActivo ){

            //     let municipios = $scope.ids_municipios;
            //     let productos = $scope.ids_productos;

            //     reportService.filtrarProductosPublicos( { municipios, productos }, pagina ).then( ({data}) => {
            //         $scope.misProductos = data.data;
            //         // console.log(data.data)
            //     }, ( error ) => {
            //         if(error.status == 401){
            //             authService.logout();
            //         }
            //     });

            // }else{
                reportService.obtenerTipoProductos( pagina ).then( ( { data } ) => {
                    $scope.tipo_productos = data.data;
                }, ( error ) => {
                    if(error.status == 401){
                        authService.logout();
                    }
                });
            // }
        }

        $scope.nuevoTipoProducto = () => {
            Upload.upload({
                url: 'https://mevi.masrecursosmashumanos.com/api/api/tipo-productos/nueva',
                data: {
                    nombre: $scope.tipo_producto,
                    id_categoria: $scope.id_categoria,
                    id_unidad: $scope.id_unidad,
                    imagenes: document.getElementById('imagenes').files
                },
                params: {token: $scope.token}
            }).then( ( data ) => {
                $scope.tipoProductos();
                $scope.tipo_producto = '';
                $scope.id_categoria = '';
                $scope.id_unidad = '';
            }, ( { data } ) => {
                $scope.errores = data;
                // document.getElementById('btn-submit').style.display="block";
                // if(error.status == 401){
                //     alert(error.data.message);
                // }else if(error.status == 422){
                //     $scope.errores = true;
                // }
            });

            $scope.actualizar = false;
        }

        $scope.editarTipoProducto = ({ tipo_producto }) => {
            console.log(tipo_producto)
            $scope.tipo_producto = tipo_producto.nombre;
            $scope.id_categoria = tipo_producto.id_categoria.toString();
            $scope.id_unidad = tipo_producto.id_unidad.toString();
            $scope.id_tipo_producto = tipo_producto.id;

            $scope.actualizar = true;
        }

        // $scope.imagen = ( id ) => {
        //     return 'https://mevi.masrecursosmashumanos.com/api/api/imagenes/'+id;
        // }

        $scope.actualizarTipoProducto = () => {

            if( $scope.actualizar ){

                Upload.upload({
                    url: 'https://mevi.masrecursosmashumanos.com/api/api/tipo-productos',
                    data: {
                        id_tipo_producto: $scope.id_tipo_producto,
                        nombre: $scope.tipo_producto,
                        id_categoria: $scope.id_categoria,
                        id_unidad: $scope.id_unidad,
                        imagenes: document.getElementById('imagenes').files
                    },
                    params: {token: $scope.token}
                }).then( ( data ) => {
                    // location.reload();
                    console.log(data)
                    $scope.tipoProductos();
                    $scope.tipo_producto = '';
                    $scope.id_categoria = '';
                    $scope.id_unidad = '';
                }, ( { data } ) => {
                    $scope.errores = data;
                    // document.getElementById('btn-submit').style.display="block";
                    // if(error.status == 401){
                    //     alert(error.data.message);
                    // }else if(error.status == 422){
                    //     $scope.errores = true;
                    // }
                });

            }else{
                alert('No se ha seleccionado tipo de producto para actualizar.');
            }
        }

        $scope.buscar = () => {
            $scope.errores = [];

            if($scope.tipo_producto){
                console.log($scope.tipo_producto)
            }
        }

 

});
