var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoRegistrarEditarProductoProveedorController',
    function ($scope, reportService,userService, socketService, Upload, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.path = window.location.pathname.split('/')[1];

        $scope.descuento = false;

        $scope.api = reportService.api();

        $scope.obtenerProducto = ( ) => {

            if( $scope.path === 'editar-producto-proveedor' ) {

                document.getElementById('categorias').disabled = true;
                document.getElementById('productos').disabled = true;

                reportService.obtenerProductoProveedor( $routeParams.id ).then( ( { data } ) => {
                    console.log(data)
                    $scope.id_producto_db = data.id;
                    $scope.id_producto = data.id;
                    $scope.id_categoria = data.tipo_producto.id_categoria.toString();
                    $scope.filtrarProductos(data.tipo_producto.id_categoria);
                    $scope.id_producto = data.id_tipo_producto.toString();
                    $scope.unidad = data.tipo_producto.unidad.nombre;
                    $scope.descripcion = data.descripcion;
                    $scope.precio = data.stocks[ data.stocks.length - 1 ].valor_stock;
                    $scope.obtenerDepartamentos( data.municipio.departamento.id );
                    $scope.departamento = data.municipio.departamento.id.toString();
                    // $scope.filtrarMunicipios( data.municipio.departamento.id );
                    $scope.id_municipio = data.id_municipio.toString();
                    $scope.cantidad = data.stocks[ data.stocks.length - 1 ].stock;
                    $scope.descuento = data.stocks[ data.stocks.length - 1 ].descuento === 10 ? true : false;
                }, ( error ) => {
                    // if(error.status == 401){
                    //     authService.logout();
                    // }
                });

            }

        }

        $scope.obtenerDepartamentos = ( id_departamento ) => {
            reportService.obtenerDepartamentos(  ).then( ( { data } ) => {
                $scope.departamentos = data;

                if( id_departamento ){
                    $scope.municipios = $scope.departamentos.find( ( { id } ) => id == id_departamento )['municipios'];
                }
            }, ( error ) => {
                if(error.status == 401){
                    authService.logout();
                }
            });
        }


        reportService.obtenerCategoriasProveedoresAdministrador(  ).then( ( { data } ) => {
            // console.log(data)
            $scope.categorias = data;

            $scope.categorias.sort(function (a, b) {
                if (a.nombre > b.nombre) {
                  return 1;
                }
                if (a.nombre < b.nombre) {
                  return -1;
                }
                // a must be equal to b
                return 0;
            });

            $scope.obtenerProducto();
            $scope.obtenerDepartamentos();
        }, ( error ) => {
            console.log(error)
            // if(error.status == 401){
            //     authService.logout();
            // }
        });

        reportService.obtenerUnidades(  ).then( ( { data } ) => {
            $scope.unidades = data;
        }, ( error ) => {
            if(error.status == 401){
                authService.logout();
            }
        });

        $scope.filtrarProductos = ( id_categoria ) => {
            if($scope.id_categoria === '') {
                $scope.productos = [];
            }else{
                var hash = {};
                $scope.productos = $scope.categorias.find( ( { id } ) => id ==  $scope.id_categoria ||id_categoria )['tipos_productos_proveedores'];
                $scope.productos = $scope.productos.map(function(current) {
                    let p = {...current}
                    p.nombre = p.nombre.trim();
                    return p;
                });

                $scope.productos.sort(function (a, b) {
                    if (a.nombre > b.nombre) {
                      return 1;
                    }
                    if (a.nombre < b.nombre) {
                      return -1;
                    }
                    // a must be equal to b
                    return 0;
                });

                // console.log( $scope.productos );
            }
        }

        $scope.validarDescuento = () => {
            if( $scope.descuento < 0 || $scope.descuento > 20){
                alert('El descuento no esta dentro del rango establecido.');
                delete $scope.descuento;
            }
        }

        $scope.filtrarMunicipios = ( id_departamento ) => {
            if($scope.departamento === '') {
                $scope.municipios = [];
            }else{
                $scope.municipios = $scope.departamentos.find( ( { id } ) => id == $scope.departamento || id_departamento )['municipios'];
            }
        }

        $scope.mostrarUnidad = ( id_producto ) => {
            if($scope.id_producto === '') {
                $scope.unidad = '';
            }else{
                let producto = $scope.productos.find( ( { id } ) => id == $scope.id_producto || id_producto );

                if( producto ){
                    $scope.unidad = producto['unidad']['nombre'];
                }else{
                    $scope.unidad = '';
                }
                
                
            }
        }

        $scope.errores = false;

        $scope.registrarProducto = ( ) => {

            if( $scope.path === 'editar-producto-proveedor' ) {
                
                let data = {
                    id: $scope.id_producto_db,
                    id_producto: $scope.id_producto,
                    descripcion: $scope.descripcion,
                    precio: $scope.precio,
                    id_municipio: $scope.id_municipio,
                    cantidad: $scope.cantidad,
                    descuento: $scope.descuento ? 10 : 0
                    // imagenes: document.getElementById('imagenes').files
                }

                console.log(data)

                reportService.actualizarProducto( data ).then( ( { data: { message } } ) => {
                    alert( message );
                }, ( error ) => {
                    document.getElementById('btn-submit').style.display="block";
                    if(error.status == 401){
                        alert(error.data.message);
                    }else if(error.status == 422){
                        $scope.errores = true;
                    }
                });

            }else{

                document.getElementById('btn-submit').style.display="none";

                Upload.upload({
                    url: `${$scope.api}/api/proveedores/productos/nuevo`,
                    data: {
                        producto: $scope.producto,
                        descripcion: $scope.descripcion,
                        id_categoria: $scope.id_categoria,
                        unidad_venta: $scope.unidad,
                        precio: $scope.precio,
                        id_municipio: $scope.id_municipio,
                        cantidad: $scope.cantidad,
                        descuento: 0
                        // descuento: $scope.descuento ? 10 : 0
                        // imagenes: document.getElementById('imagenes').files
                    },
                    params: {token: $scope.token}
                }).then( ( { data: { message } } ) => {
                    alert( message );
                    socketService.emit('nuevosProductos', 0);
                    $location.path('/mis-productos-proveedor');
                    // delete $scope.id_producto;
                    // delete $scope.descripcion;
                    // delete $scope.precio;
                    // delete $scope.id_municipio;
                    // delete $scope.cantidad;

                    // document.getElementById('btn-submit').style.display="block";

                }, ( error ) => {
                    document.getElementById('btn-submit').style.display="block";
                    if(error.status == 401){
                        alert(error.data.message);
                    }else if(error.status == 422){
                        $scope.errores = true;
                    }
                });

            }

        }

});