var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoRegistrarEditarProductoController',
    function ($scope, reportService,userService, socketService, Upload, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.path = window.location.pathname.split('/')[1];

        $scope.descuento = false;

        $scope.obtenerProducto = ( ) => {

            if( $scope.path === 'editar-producto' ) {

                document.getElementById('categorias').disabled = true;
                document.getElementById('productos').disabled = true;

                reportService.obtenerProducto( $routeParams.id ).then( ( { data } ) => {
                    $scope.id_producto_db = data.id;
                    $scope.id_producto = data.id;
                    $scope.id_categoria = data.tipo_producto.id_categoria.toString();
                    $scope.filtrarProductos(data.tipo_producto.id_categoria);
                    $scope.id_producto = data.id_tipo_producto.toString();
                    $scope.unidad = data.tipo_producto.unidad.nombre;
                    $scope.descripcion = data.descripcion;
                    $scope.precio = data.stocks[ data.stocks.length - 1 ].valor_stock;
                    $scope.obtenerDepartamentos( data.municipio.departamento.id );
                    $scope.departamento = data.municipio.departamento.id.toString();
                    // $scope.filtrarMunicipios( data.municipio.departamento.id );
                    $scope.id_municipio = data.id_municipio.toString();
                    $scope.cantidad = data.stocks[ data.stocks.length - 1 ].stock;
                    $scope.descuento = data.stocks[ data.stocks.length - 1 ].descuento === 10 ? true : false;
                }, ( error ) => {
                    // if(error.status == 401){
                    //     authService.logout();
                    // }
                });

            }

        }

        $scope.obtenerDepartamentos = ( id_departamento ) => {
            reportService.obtenerDepartamentos(  ).then( ( { data } ) => {
                $scope.departamentos = data;

                if( id_departamento ){
                    $scope.municipios = $scope.departamentos.find( ( { id } ) => id == id_departamento )['municipios'];
                }
            }, ( error ) => {
                if(error.status == 401){
                    authService.logout();
                }
            });
        }


        reportService.obtenerCategorias(  ).then( ( { data } ) => {
            $scope.categorias = data;
            $scope.obtenerProducto();
            $scope.obtenerDepartamentos();
        }, ( error ) => {
            // if(error.status == 401){
            //     authService.logout();
            // }
        });

        reportService.obtenerUnidades(  ).then( ( { data } ) => {
            $scope.unidades = data;
        }, ( error ) => {
            if(error.status == 401){
                authService.logout();
            }
        });

        $scope.filtrarProductos = ( id_categoria ) => {
            if($scope.id_categoria === '') {
                $scope.productos = [];
            }else{
                $scope.productos = $scope.categorias.find( ( { id } ) => id ==  $scope.id_categoria ||id_categoria )['tipos_productos'];
                // console.log($scope.productos)
            }
        }

        $scope.validarDescuento = () => {
            if( $scope.descuento < 0 || $scope.descuento > 20){
                alert('El descuento no esta dentro del rango establecido.');
                delete $scope.descuento;
            }
        }

        $scope.filtrarMunicipios = ( id_departamento ) => {
            if($scope.departamento === '') {
                $scope.municipios = [];
            }else{
                $scope.municipios = $scope.departamentos.find( ( { id } ) => id == $scope.departamento || id_departamento )['municipios'];
            }
        }

        $scope.mostrarUnidad = ( id_producto ) => {
            if($scope.id_producto === '') {
                $scope.unidad = '';
            }else{
                let producto = $scope.productos.find( ( { id } ) => id == $scope.id_producto || id_producto );

                if( producto ){
                    $scope.unidad = producto['unidad']['nombre'];
                }else{
                    $scope.unidad = '';
                }
                
                
            }
        }

        $scope.errores = false;

        $scope.registrarProducto = ( ) => {

            if( $scope.path === 'editar-producto' ) {
                
                let data = {
                    id: $scope.id_producto_db,
                    id_producto: $scope.id_producto,
                    descripcion: $scope.descripcion,
                    precio: $scope.precio,
                    id_municipio: $scope.id_municipio,
                    cantidad: $scope.cantidad,
                    descuento: $scope.descuento ? 10 : 0
                    // imagenes: document.getElementById('imagenes').files
                }

                console.log(data)

                reportService.actualizarProducto( data ).then( ( { data: { message } } ) => {
                    alert( message );
                }, ( error ) => {
                    // console.log( error )
                    // if(error.status == 401){
                    //     authService.logout();
                    // }
                });

            }else{

                document.getElementById('btn-submit').style.display="none";

                Upload.upload({
                    url: 'https://mevi.masrecursosmashumanos.com/api/api/productos/nuevo',
                    data: {
                        id_producto: $scope.id_producto,
                        descripcion: $scope.descripcion,
                        precio: $scope.precio,
                        id_municipio: $scope.id_municipio,
                        cantidad: $scope.cantidad,
                        descuento: $scope.descuento ? 10 : 0
                        // imagenes: document.getElementById('imagenes').files
                    },
                    params: {token: $scope.token}
                }).then( ( { data: { message } } ) => {
                    alert( message );
                    socketService.emit('nuevosProductos', 0);
                    $location.path('/mis-productos');
                }, ( error ) => {
                    document.getElementById('btn-submit').style.display="block";
                    if(error.status == 401){
                        alert(error.data.message);
                    }else if(error.status == 422){
                        $scope.errores = true;
                    }
                });

            }

        }

});