var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoPerfilController',
    function ($scope, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

    $scope.registro = {id_municipio: '', segundo_nombre: '', segundo_apellido: ''};
    $scope.departamentos = [];
    $scope.departamento = '';
    $scope.municipios = [];

    reportService.obtenerDepartamentos(  ).then( ( { data } ) => {
        $scope.departamentos = data;

        reportService.obtenerMiInformacion(  ).then( ( { data } ) => {

            $scope.registro.primer_nombre = data.primer_nombre;
            $scope.registro.segundo_nombre = data.segundo_nombre;
            $scope.registro.primer_apellido = data.primer_apellido;
            $scope.registro.segundo_apellido = data.segundo_apellido;
            $scope.registro.cedula = parseInt( data.cedula );
            $scope.registro.telefono = parseInt( data.telefono );
            $scope.registro.email = data.email;
            $scope.registro.email_confirmation = data.email;
            $scope.departamento = data.municipio.departamento.id.toString();
            $scope.municipios = $scope.departamentos.find( departamento => departamento.id == data.municipio.departamento.id ).municipios;
            $scope.registro.id_municipio = data.municipio.id.toString();
            $scope.registro.direccion = data.direccion;

        }, ( error ) => {
            if(error.status == 401){

            }
        });

    }, ( error ) => {
        if(error.status == 401){

        }
    });






    $scope.actualizar = ( ) => {

        if($scope.registro.password === ''){
            delete $scope.registro.password;
            delete $scope.registro.password_confirmation;
        }

        if($scope.registro.email === ''){
            delete $scope.registro.email;
            delete $scope.registro.email_confirmation;
        }

        if($scope.registro.segundo_nombre === ''){
            delete $scope.registro.segundo_nombre;
        }

        if($scope.registro.segundo_apellido === ''){
            delete $scope.registro.segundo_apellido;
        }

        reportService.actualizarMiInformacion( $scope.registro ).then( ( { data: { message } } ) => {
            delete $scope.registro.password;
            delete $scope.registro.password_confirmation;
            alert( message );
        }, ( error ) => {
            // console.log(error)
            
            if(error.status == 401){
                
            }else if(error.status == 422){
                $scope.errores = error.data;
            }else if(error.status == 403){
                alert(error.data.message)
            }
        });

    }

    $scope.filtrarMunicipios = ( ) => {
        if($scope.departamento === '') {
            $scope.municipios = [];
        }else{
            $scope.municipios = $scope.departamentos.find( ( { id } ) => id == $scope.departamento )['municipios'];
        }
    }

});

