var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoOfertasProveedorController',
    function ($scope, reportService,userService, authService, socketService, $routeParams,$uibModal, $location, $interval,$window) {

        const id_carrito = $routeParams.id;

        $scope.api = reportService.api();

        $scope.cantidad_alterada = '';
        $scope.nueva_cantidad = '';
        $scope.valor_alterado = '';
        $scope.nuevo_valor = '';
        $scope.nuevo_stock = '';

        $scope.ofertas = [];

        reportService.obtenerOfertasProveedor( id_carrito ).then( ( { data } ) => {

            console.log(data)

            $scope.carrito = data;

            // $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
            // $scope.unidad = data.tipo_producto.unidad.nombre;

        }, ( error ) => {
            if(error.status == 404){
                // $location.path('/compra');
            }
        });

        $scope.actualizarOferta = ( { producto }, indice ) => {
            $scope.cantidad_alterada = '';
            $scope.nueva_cantidad = '';
            $scope.valor_alterado = '';
            $scope.nuevo_valor = '';
            $scope.nuevo_stock = '';

            $scope.ofertaSeleccionada = producto;
            // console.log(producto)
            if( producto.oferta.estado === 'ACEPTADO' ){

                $scope.carrito.carrito_productos[indice].oferta.estado = 'EN PROCESO';
                $('#modal_oferta').modal('show');

            }else if( producto.oferta.estado === 'RECHAZADO' ){

                let confirmacion = confirm('¿Seguro de realizar esta acción?, luego no se podra modificar.');

                if( confirmacion ){
                    let data = {
                        // cantidad_alterada: $scope.cantidad_alterada,
                        // nueva_cantidad: $scope.cantidad_alterada === 'No' ? $scope.nueva_cantidad : $scope.ofertaSeleccionada.cantidad,
                        // valor_alterado: $scope.valor_alterado,
                        // nuevo_valor: $scope.valor_alterado === 'No' ? $scope.nuevo_valor : $scope.ofertaSeleccionada.valor_unitario,
                        // nuevo_stock: $scope.nuevo_stock,
                        id_oferta: $scope.ofertaSeleccionada.oferta.id,
                        nuevo_estado: 'RECHAZADO',
                        id_producto: $scope.ofertaSeleccionada.oferta.id_producto,
                    }

                    reportService.enviarOfertaProveedorActualizada( data ).then( ( { data } ) => {

                        $scope.carrito = data;
                        // $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
                        // $scope.unidad = data.tipo_producto.unidad.nombre;
                        // socketService.emit('actualizarNotificacionesInterecesCompra', $scope.ofertaSeleccionada.id_user);
                        $('#modal_oferta').modal('hide');
                        alert('Estado del producto actualizado correctamente');

                    }, ( error ) => {

                    });
                }else{
                    $scope.ofertas.ofertas[indice].estado = 'EN PROCESO';
                }

            }else if( producto.oferta.estado === 'EN PROCESO' ){

            }
        }

        $scope.verOferta = ( { oferta } ) => {
            $scope.ofertaSeleccionada = oferta;
        }

        $scope.enviarOfertaActualizada = () => {

            let confirmacion = confirm('¿Seguro de realizar esta acción?, luego no se podra modificar.');

            if( confirmacion ){
                let data = {
                    cantidad_alterada: $scope.cantidad_alterada,
                    nueva_cantidad: $scope.cantidad_alterada === 'No' ? $scope.nueva_cantidad : $scope.ofertaSeleccionada.cantidad,
                    valor_alterado: $scope.valor_alterado,
                    nuevo_valor: $scope.valor_alterado === 'No' ? $scope.nuevo_valor : $scope.ofertaSeleccionada.oferta.valor_unitario,
                    nuevo_stock: $scope.nuevo_stock,
                    id_oferta: $scope.ofertaSeleccionada.oferta.id,
                    nuevo_estado: 'ACEPTADO',
                    id_producto: $scope.ofertaSeleccionada.oferta.id_producto,
                    metodo_pago: $scope.metodo_pago,
                    metodo_envio: $scope.metodo_envio,
                    valor_envio: $scope.valor_envio,
                    id_carrito: id_carrito
                }

                reportService.enviarOfertaProveedorActualizada( data ).then( ( { data } ) => {

                    // socketService.emit('actualizarNotificacionesInterecesCompra', $scope.ofertaSeleccionada.id_user);

                    $scope.carrito = data;
                    // $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
                    // $scope.unidad = data.tipo_producto.unidad.nombre;
                    $('#modal_oferta').modal('hide');

                    alert('Estado del producto actualizado correctamente');

                }, ( error ) => {

                    // console.log(error)

                });
            }

        }

});