var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoOfertasController',
    function ($scope, $rootScope, socketService, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.ofertas = [];

        const socket = socketService.io();

        $scope.notification_productos = $rootScope.notificaciones;
        $scope.notification_proveedores = $rootScope.notificacionesProveedor;
        $scope.notification_inclusionProductiva = $rootScope.notificacionesInclusionProductiva;

        $scope.tipo_oferta = 'proveedores';

        $scope.obtenerOfertas = ( oferta ) => {
            reportService.obtenerOfertas( oferta ).then( ( { data } ) => {
                $scope.ofertas = data;
    
                $rootScope.actualizarNotificaciones( $scope.ofertas.length );
    
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });

            reportService.obtenerOfertas( oferta ).then( ( { data } ) => {
                $scope.ofertas = data;
    
                $rootScope.actualizarNotificacionesInclusion( $scope.ofertas.length );
    
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });

            reportService.obtenerNumeroOfertas( ).then( ( { data } ) => {
                $scope.notification_productos = parseInt( data );

                reportService.obtenerNumeroOfertasProveedor( ).then( ( { data } ) => {
                    $scope.notification_proveedores = parseInt( data );
                    // $scope.totalNotificaciones = $rootScope.notificaciones + $rootScope.notificacionesProveedor;

                }, ( { status, data: { message } } ) => {

                });

            }, ( { status, data: { message } } ) => {

            });
        }

        $scope.obtenerOfertas( $scope.tipo_oferta );

        $scope.consultarListado = () => {
            if( $scope.tipo_oferta == 'productos' ){
                $scope.obtenerOfertas( 'productos' );
            }else if( $scope.tipo_oferta == 'proveedores' ){
                $scope.obtenerOfertas( 'proveedores' );
            }else if( $scope.tipo_oferta == 'inclusion' ){
                $scope.obtenerOfertas( 'inclusion' );
            }

        }

        socket.on("actualizarOfertas", function ( ) {
            $scope.obtenerOfertas();
        });
       
});