/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoNavbarController',
    function ($scope,authService,$location, socketService, reportService, $rootScope){

        $scope.path = window.location.pathname.split('/')[1];

        $scope.loggin = localStorage.getItem("satellizer_token");
        $scope.notificaciones = 0;
        $scope.notificaciones_intereces = 0;
        $scope.notificacionesCarrito = 0;

        $rootScope.sistema = [];

        const url = window.location.origin;

        const socket = socketService.io();

        $rootScope.habilitarMenu = () => {
            $scope.loggin = localStorage.getItem("satellizer_token");

            socketService.emit('registrar', localStorage.getItem("satellizer_key"));

            $scope.obtenerOfertas();

            const opciones = JSON.parse(localStorage.getItem('satellizer_paths'));

            if(opciones.length > 0){
                $scope.opcionesMenu = opciones[0].opciones;
                $scope.opcionesSistema = opciones[1] ? opciones[1].opciones : [];
            }

            
            location.href="/proveedores";
        };

        $rootScope.actualizarNotificaciones = ( ofertas ) => {
            $scope.notificaciones = ofertas;
        };

        $rootScope.actualizarNotificacionesInclusion = ( ofertas ) => {
            $scope.notificaciones_inclusionProductiva = ofertas;
        };

        $rootScope.actualizarNotificacionesCarrito = (  ) => {

            reportService.notificacionesCarrito(  ).then( ( { data: { carrito_proveedores = [] } } ) => {

                $scope.notificacionesCarrito = 0;
                carrito_proveedores.map( ( { carrito_productos_count } ) => {
                    $scope.notificacionesCarrito += carrito_productos_count;
                } );

                document.getElementById('notificacionesCarrito').innerHTML = $scope.notificacionesCarrito;

            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });

        };

        $rootScope.actualizarNotificacionesCarrito();




        $scope.reporte = ( path ) => {
            // console.log(`${url}/api/api/${path}`)
            location.href = `${url}/api/api/${path}`;
        }

        let actualizarNotificacionesInterecesCompra = ( ) => {
            reportService.respuestaOfertas(  ).then( ( { data } ) => {
                $scope.notificaciones_intereces = data;
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });

        };

        if($scope.loggin !== null){
            socketService.emit('registrar', localStorage.getItem("satellizer_key"));
            actualizarNotificacionesInterecesCompra( );

            const opciones = JSON.parse(localStorage.getItem('satellizer_paths'));
            if(opciones.length > 0){
                $scope.opcionesMenu = opciones[0].opciones;
                $scope.opcionesSistema = opciones[1];
                $rootScope.sistema = $scope.opcionesSistema;
            }
        }

        $scope.cerrarSesion = () => {
            let opcion = confirm('La sesión se cerrará. ¿Desea continuar?');

            if( opcion ) {
                localStorage.clear();
                $scope.loggin = localStorage.getItem("satellizer_token");
                $scope.opcionesMenu = [];
                $scope.opcionesSistema = [];
                $rootScope.sistema = $scope.opcionesSistema;
                $location.path('/');
            }

        }

        $scope.obtenerOfertas = () => {
            reportService.obtenerNumeroOfertas( ).then( ( { data } ) => {
                $rootScope.notificaciones = parseInt( data );

                reportService.obtenerNumeroOfertasProveedor( ).then( ( { data } ) => {
                    $rootScope.notificacionesProveedor = parseInt( data );
                    $scope.totalNotificaciones = $rootScope.notificaciones + $rootScope.notificacionesProveedor;

                }, ( { status, data: { message } } ) => {

                });

            }, ( { status, data: { message } } ) => {

            });

        }

        $scope.obtenerOfertas();

        $rootScope.restarNotificacionesInterecesCompra = ( { id, visto } ) => {

            if( visto == 'SI' ){
                $location.path(`/contacto-vendedor/${id}`);
            }else{
                reportService.visadoNotificacionInteres( id ).then( ( { data } ) => {
                    $scope.notificaciones_intereces = data;
                    $location.path(`/contacto-vendedor/${id}`);
                }, ( error ) => {
    
                });
            }

        };

        $rootScope.restarNotificacionesInterecesCompraInclusionProductiva = ( { id, visto } ) => {

            if( visto == 'SI' ){
                $location.path(`/inclusion-productiva/contacto-vendedor/${id}`);
            }else{
                reportService.visadoNotificacionInteresInclusionProductiva( id ).then( ( { data } ) => {
                    $scope.notificaciones_intereces_inclusiones = data;
                    $location.path(`/inclusion-productiva/contacto-vendedor/${id}`);
                }, ( error ) => {
    
                });
            }

        };

        socket.on("actualizarOfertas", function ( ) {
            $scope.obtenerOfertas();
        });

        socket.on("actualizarNotificacionesInterecesCompra", function ( ) {
            actualizarNotificacionesInterecesCompra();
        });



});



