var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoLoginController', ['$scope', 'authService', '$location', '$rootScope', 'reportService',
function ($scope, authService, $location, $rootScope, reportService) {

    $scope.user = {
        cedula: "",
        password: ""
    };

    $scope.mensaje = '';
    $scope.errores = {};


    $scope.login = ( ) => {

        reportService.login($scope.user).then( ( { data: { token, key, rutas } } ) => {
            localStorage.setItem("satellizer_token", token);
            localStorage.setItem("satellizer_key", key);
            localStorage.setItem("satellizer_paths", JSON.stringify(rutas));

            $rootScope.habilitarMenu();
            $scope.mensaje = '';
            $scope.errores = {};
            $location.path('/');
        }, ( { data, status } ) => {
            console.log(data)
            if( status === 401 ) {
                $scope.errores = {};
                $scope.mensaje = data.message;
            }else if( status === 422 ) {
                $scope.mensaje = '';
                $scope.errores = data;
            }

        });
    };

    $scope.ocultarMensaje = ( campo ) => {
        if( campo === 'cedula' ) {
            $scope.mensaje = '';
            $scope.errores.cedula = [];
        }else{
            $scope.mensaje = '';
            $scope.errores.password = [];
        }
    }

    $scope.loginError=function(){
        return $scope.error;
    }

}]);