var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoListadoProveedoresController',
    function ($scope, reportService,userService, socketService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.token=localStorage.getItem("satellizer_token");

        $scope.api = reportService.api();

        const socket = socketService.io();

        $scope.grid_view = true;
        $scope.list_view = false;

        $scope.mostrarVista = ( vista ) => {
            if( vista === 'grid' ){
                $scope.grid_view = true;
                $scope.list_view = false;
            }else{
                $scope.grid_view = false;
                $scope.list_view = true;
            }
        }

        $scope.pages = [];
        $scope.path = '';

        $scope.mostrarDep = false;
        $scope.iconoMostrarDep = '+';
        $scope.mostrarCat = false;
        $scope.iconoMostrarCat = '+';

        $scope.datos = {
            municipiosSeleccionados: [],
            productosSeleccionados: []
        }

        $scope.filtroActivo = false;

        $scope.listadoProveedores = () => {

            reportService.obtenerListadoProveedorActual(  ).then( ( { data } ) => {

                $scope.proveedores = data.proveedores;
                // $scope.pages = [];

                // if( data.last_page < 8 ){
                //     for (let i = 1; i <= data.last_page; i++) {
                //         $scope.pages.push(i)
                //     }
                // }else{
                //     for (let i = 1; i <= 8; i++) {
                //         if(i==7){
                //             $scope.pages.push('...')
                //         }else if(i === 8){
                //             $scope.pages.push(data.last_page)
                //         }else{
                //             $scope.pages.push(i)
                //         }
                //     }
                // }

                // $scope.path = data.path;
                // $scope.last_page = data.last_page;
                // $scope.current_page = 1;
                // $scope.total_productos = data.total;

            }, ( error ) => {
                console.log(error)
                if(error.status == 401){
                    authService.logout();
                }
            });

        }

        $scope.listadoProveedores();


        $scope.cambiarClave = ( { proveedor } ) => {

            let opcion = confirm('¿Seguro de querer cambiar la contraseña para "' + proveedor.nombre_almacen.trim() + '" ?');

            if( opcion ){
                let clave = prompt("Ingrese la nueva contraseña.");

                if( clave ){

                    reportService.cambiarPasswordProveedor( { clave, id: proveedor.id } ).then( ( {data: { message }} ) => {
    
                        alert( message );
    
                    }, ( error ) => {
                        if(error.status == 401){
                            authService.logout();
                        }
                    });
                }else{
                    alert(" Campo para la nueva contraseña es obligatorio ");
                }
            }

        }



































        socket.on("mostrarNuevosProductos", function (data) {
            // $scope.listadoProductos();
        });


        // Paginación
        $scope.setCurrent = ( pagina, indice = -1 ) => {
            $scope.current_page = pagina;
            let indice_actual = indice;

            // Comportamiento botones de paginación
            if( $scope.last_page >= 8 ){
                if( indice === -1 ){
                    $scope.pages.map( ( p, index ) => {
                        if( p === pagina ){
                            indice_actual = index
                        }
                    } );
                    
                }

                const bandera = $scope.pages[indice_actual]; // valor de la pagina seleccionada

                if( bandera === $scope.last_page ){
                    $scope.pages[1] = '...';
                    $scope.pages[indice_actual - 1] = bandera - 1;
                    $scope.pages[indice_actual - 2] = bandera - 2;
                    $scope.pages[indice_actual - 3] = bandera - 3;
                    $scope.pages[indice_actual - 4] = bandera - 4;
                    $scope.pages[indice_actual - 5] = bandera - 5;
                }else if( bandera === 1 ){
                    $scope.pages[6] = '...';
                    $scope.pages[indice_actual + 1] = bandera + 1;
                    $scope.pages[indice_actual + 2] = bandera + 2;
                    $scope.pages[indice_actual + 3] = bandera + 3;
                    $scope.pages[indice_actual + 4] = bandera + 4;
                    $scope.pages[indice_actual + 5] = bandera + 5;
                }else{
                    if($scope.pages[indice_actual + 1] === '...'){
                        // Valida el comportamiento ascendente de la paginación
                        $scope.pages[1] = '...';

                        if( pagina + 3 === $scope.last_page ){
                            $scope.pages[indice_actual + 2] = bandera + 3;
                            $scope.pages[indice_actual + 1] = bandera + 2;
                            $scope.pages[indice_actual] = bandera + 1;
                            $scope.pages[indice_actual - 1] = bandera;
                        }else if( pagina + 2 === $scope.last_page ){
                            $scope.pages[indice_actual + 1] = bandera + 1;
                        }else{
                            $scope.pages[indice_actual] = bandera + 1;
                            $scope.pages[indice_actual - 1] = bandera;
                            $scope.pages[indice_actual - 2] = bandera - 1;
                            $scope.pages[indice_actual - 3] = bandera - 2;
                        }

                    }else if($scope.pages[indice_actual - 1] === '...'){
                        // Valida el comportamiento descendente de la paginación
                        $scope.pages[6] = '...';

                        if( pagina - 3 === 1 ){
                            $scope.pages[indice_actual - 2] = bandera - 3;
                            $scope.pages[indice_actual - 1] = bandera - 2;
                            $scope.pages[indice_actual] = bandera - 1;
                            $scope.pages[indice_actual + 1] = bandera;
                        }else if( pagina - 2 === 1 ){
                            $scope.pages[indice_actual - 1] = bandera - 1;
                        }else{
                            $scope.pages[indice_actual] = bandera - 1;
                            $scope.pages[indice_actual + 1] = bandera;
                            $scope.pages[indice_actual + 2] = bandera + 1;
                            $scope.pages[indice_actual + 3] = bandera + 2;
                        }
    
                    }
                }

            }

            if( $scope.filtroActivo ){

                let municipios = $scope.ids_municipios;
                let productos = $scope.ids_productos;

                reportService.filtrarProductosPublicos( { municipios, productos }, pagina ).then( ({data}) => {
                    $scope.misProductos = data.data;
                    // console.log(data.data)
                }, ( error ) => {
                    if(error.status == 401){
                        authService.logout();
                    }
                });

            }else{
                reportService.obtenerProductos( pagina ).then( ( { data } ) => {
                    $scope.misProductos = data.data;
                    // console.log(data.data)
                }, ( error ) => {
                    if(error.status == 401){
                        authService.logout();
                    }
                });
            }
        }

        $scope.mostrarCategorias = () => {
            $scope.mostrarCat = !$scope.mostrarCat;
            $scope.iconoMostrarCat = $scope.mostrarCat ? '-' : '+';
        }

        $scope.menu_categoria = ( id_categoria ) => {

            if( id_categoria === $scope.categoria_activa ){
                document.getElementById(`submenu_categoria_${ id_categoria }`).style.display = "none";
                $scope.categoria_activa = '';
            }else{
                $scope.categorias.map( ( { id } ) => {
                    if( id === id_categoria ){
                        $scope.categoria_activa = id;
                        document.getElementById(`submenu_categoria_${ id }`).style.display = "block";
                    }else{
                        document.getElementById(`submenu_categoria_${ id }`).style.display = "none";
                    }
                } )
            }

        }

        $scope.mostrarDepartamentos = () => {
            $scope.mostrarDep = !$scope.mostrarDep;
            $scope.iconoMostrarDep = $scope.mostrarDep ? '-' : '+';
        }

        $scope.menu_departamento = ( id_departamento ) => {

            if( id_departamento === $scope.departamento_activa ){
                document.getElementById(`submenu_departamento_${ id_departamento }`).style.display = "none";
                $scope.departamento_activa = '';
            }else{
                $scope.departamentos.map( ( { id } ) => {
                    if( id === id_departamento ){
                        $scope.departamento_activa = id;
                        document.getElementById(`submenu_departamento_${ id }`).style.display = "block";
                    }else{
                        document.getElementById(`submenu_departamento_${ id }`).style.display = "none";
                    }
                } )
            }

        }

        $scope.agregarMunicipiosFiltrados = ( id_muncipio, indiceDepartamento, indiceMunicipio ) => {

            // Validamos si el municipio esta seleccionadó
            if( $scope.datos.municipiosSeleccionados.find( municipio => municipio.id === id_muncipio ) ){ // true

                // deahabilitamos el municipio y lo eliminamos de array
                $scope.departamentos[indiceDepartamento].municipios[indiceMunicipio].active = false;
                $scope.datos.municipiosSeleccionados = $scope.datos.municipiosSeleccionados.filter( municipio => municipio.id != id_muncipio );

            }else{
                // habilitamos el municipio y lo agregamos al array
                $scope.departamentos[indiceDepartamento].municipios[indiceMunicipio].active = true;
                $scope.datos.municipiosSeleccionados = [
                    ...$scope.datos.municipiosSeleccionados,
                    {
                        id: id_muncipio,
                        nombre: $scope.departamentos[indiceDepartamento].municipios[indiceMunicipio].nombre,
                        indiceDepartamento,
                        indiceMunicipio
                    }
                ];
            }


        }

        $scope.agregarProductosFiltrados = ( id_producto, indiceCategoria, indiceProducto ) => {

            // Validamos si el producto esta seleccionadó
            if( $scope.datos.productosSeleccionados.find( producto => producto.id === id_producto ) ){ // true

                // deahabilitamos el producto y lo eliminamos de array
                $scope.categorias[indiceCategoria].tipos_productos[indiceProducto].active = false;
                $scope.datos.productosSeleccionados = $scope.datos.productosSeleccionados.filter( producto => producto.id != id_producto );

            }else{
                // habilitamos el producto y lo agregamos al array
                $scope.categorias[indiceCategoria].tipos_productos[indiceProducto].active = true;
                $scope.datos.productosSeleccionados = [
                    ...$scope.datos.productosSeleccionados,
                    {
                        id: id_producto,
                        nombre: $scope.categorias[indiceCategoria].tipos_productos[indiceProducto].nombre,
                        indiceCategoria,
                        indiceProducto
                    }
                ];
            }
        }

        $scope.filtrar = () => {

            let municipios = $scope.datos.municipiosSeleccionados.map( municipio => municipio.id);
            $scope.ids_municipios = municipios;
            let productos = $scope.datos.productosSeleccionados.map( producto => producto.id );
            $scope.ids_productos = productos;

            reportService.filtrarProductosPublicos( { municipios, productos } ).then( ({data}) => {

                $scope.filtroActivo = true;

                $scope.misProductos = data.data;
                $scope.pages = [];
                if( data.last_page < 8 ){
                    for (let i = 1; i <= data.last_page; i++) {
                        $scope.pages.push(i)
                    }
                }else{
                    for (let i = 1; i <= 8; i++) {
                        if(i==7){
                            $scope.pages.push('...')
                        }else if(i === 8){
                            $scope.pages.push(data.last_page)
                        }else{
                            $scope.pages.push(i)
                        }
                    }
                }

                $scope.path = data.path;
                $scope.last_page = data.last_page;
                $scope.current_page = 1;
                $scope.total_productos = data.total;


            }, ( error ) => {
                // console.log(error)
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.reiciarFiltro = () => {

            if($scope.datos.productosSeleccionados.length > 0){
                $scope.datos.productosSeleccionados.map( ({ indiceCategoria, indiceProducto }) => {
                    $scope.categorias[indiceCategoria].tipos_productos[indiceProducto].active = false;
                } )

                $scope.datos.productosSeleccionados = [];
            }

            if($scope.datos.municipiosSeleccionados.length > 0){
                $scope.datos.municipiosSeleccionados.map( ({ indiceDepartamento, indiceMunicipio }) => {
                    $scope.departamentos[indiceDepartamento].municipios[indiceMunicipio].active = false;
                } )

                $scope.datos.municipiosSeleccionados = [];
            }

            if( $scope.filtroActivo ){
                $scope.listadoProductos();

                $scope.filtroActivo = false;
            }

        }

        $scope.realizarIntencion = () => {
            $('#modal_oferta').modal('show');
        }

});