var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoInclusionProductivaSesionesController', ['$scope', 'authService', '$location', '$rootScope', 'reportService', 'socketService',
function ($scope, authService, $location, $rootScope, reportService, socketService) {

    const socket = socketService.io();

    $scope.dataSesion = {
        nombre: '',
        link: '',
        estado: 'NO DISPONIBLE'
    }

    const token = localStorage.getItem("satellizer_token");

    const tipo = localStorage.getItem("satellizer_key");

    const usuarios_sesion = [6568, 6569, 6570, 11988, 50478, 50479, 50480, 50481, 50482, 50483, 50484, 50485, 50486, 50487, 50488, 50489, 50490, 50491];

    $scope.privilegios = usuarios_sesion.find( user => user == tipo ) ? true : false;

    const select = [6568, 6569, 6570, 11988];

    $scope.show_select = select.find( user => user == tipo ) ? true : false;

    $scope.visible = true;

    $scope.boton = '';

    const sesiones = ( ) => {

        reportService.obtenerSesiones( token ).then( ( { data } ) => {

            $scope.sesiones = data;

        }, ( { data, status } ) => {
            // if( status === 401 ) {
            //     $scope.errores = {};
            //     $scope.mensaje = data.message;
            // }else if( status === 422 ) {
            //     $scope.mensaje = '';
            //     $scope.errores = data;
            // }
        });
    };

    sesiones();

    socket.on("mostrarNuevasSesiones", function (data) {
        sesiones();
    });


    $scope.nuevaSesion = () => {
        $scope.boton = 'Crear';

        $scope.dataSesion = {
            nombre: '',
            link: '',
            estado: 'NO DISPONIBLE'
        };

        $('#modal_sesion').modal('show');
    }

    $scope.editarSesion = ( { sesion } ) => {
        $scope.dataSesion = { ...sesion, id_municipio: `${sesion.id_municipio}` };
        $scope.boton = 'Actualizar';
        $('#modal_sesion').modal('show');
    }

    $scope.enviarDatosSesion = () => {

        if( $scope.boton == 'Crear' ){

            $scope.visible = false;

            reportService.crearSesion($scope.dataSesion).then( ( { data } ) => {

                socketService.emit('nuevasSesiones', 0);
                alert(data.message);
                $('#modal_sesion').modal('hide');
                $scope.sesiones = data.sesiones;
                $scope.visible = true;
    
            }, ( { data, status } ) => {

                $scope.visible = true;
                
            });

        }else if( $scope.boton == 'Actualizar' ){

            $scope.visible = false;

            reportService.editarSesion($scope.dataSesion).then( ( { data } ) => {

                socketService.emit('nuevasSesiones', 0);
                alert(data.message);
                $('#modal_sesion').modal('hide');
                $scope.sesiones = data.sesiones;
                $scope.visible = true;
    
            }, ( { data, status } ) => {

                $scope.visible = true;
                
            });

        }

    }

    $scope.eliminarSesion = ( { sesion } ) => {

        let confirmar = confirm('Desea eliminar la sesión');

        if( confirmar ){

            reportService.eliminarSesion(sesion.id).then( ( { data } ) => {

                socketService.emit('nuevasSesiones', 0);
                alert(data.message);
                $scope.sesiones = data.sesiones;
    
            }, ( { data, status } ) => {
                
            });

        }
        
    }

}]);