var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoInclusionProductivaOfertasProductoController',
    function ($scope, reportService,userService, authService, socketService, $routeParams,$uibModal, $location, $interval,$window) {

        const id_producto = $routeParams.id;

        $scope.api = reportService.api();

        $scope.cantidad_alterada = '';
        $scope.nueva_cantidad = '';
        $scope.valor_alterado = '';
        $scope.nuevo_valor = '';
        $scope.nuevo_stock = '';

        $scope.ofertas = [];

        reportService.obtenerOfertasProductoInclusionProductiva( id_producto ).then( ( { data } ) => {

            $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
            $scope.unidad = data.tipo_producto.unidad.nombre;

            $scope.img = data.tipo_producto.imagenes[0];

            $scope.imgs = [];

            data.tipo_producto.imagenes.map( (imagen, index) => {
                if(index > 0){
                    $scope.imgs = [ ...$scope.imgs, imagen ];
                }
            })

            $scope.ofertas = data;
            console.log(data)
        }, ( error ) => {
            if(error.status == 404){
                // $location.path('/compra');
            }
        });

        $scope.actualizarOferta = ( { oferta }, indice ) => {
            $scope.cantidad_alterada = '';
            $scope.nueva_cantidad = '';
            $scope.valor_alterado = '';
            $scope.nuevo_valor = '';
            $scope.nuevo_stock = '';

            $scope.ofertaSeleccionada = oferta;
            if( oferta.estado === 'ACEPTADO' ){

                $scope.ofertas.ofertas[indice].estado = 'EN PROCESO';
                $('#modal_oferta').modal('show');

            }else if( oferta.estado === 'RECHAZADO' ){

                let confirmacion = confirm('¿Seguro de realizar esta acción?, luego no se podra modificar.');

                if( confirmacion ){
                    let data = {
                        // cantidad_alterada: $scope.cantidad_alterada,
                        // nueva_cantidad: $scope.cantidad_alterada === 'No' ? $scope.nueva_cantidad : $scope.ofertaSeleccionada.cantidad,
                        // valor_alterado: $scope.valor_alterado,
                        // nuevo_valor: $scope.valor_alterado === 'No' ? $scope.nuevo_valor : $scope.ofertaSeleccionada.valor_unitario,
                        // nuevo_stock: $scope.nuevo_stock,
                        id_oferta: $scope.ofertaSeleccionada.id,
                        nuevo_estado: 'RECHAZADO',
                        id_producto: $scope.ofertas.id
                    }
    
                    reportService.enviarOfertaActualizadaInclusionProductiva( data ).then( ( { data } ) => {
    
                        // console.log(data)
                        $scope.ofertas = data;
                        $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
                        $scope.unidad = data.tipo_producto.unidad.nombre;
                        socketService.emit('actualizarNotificacionesInterecesCompra', $scope.ofertaSeleccionada.id_user);
                        $('#modal_oferta').modal('hide');
        
                    }, ( error ) => {
        
                        // console.log(error)
        
                    });
                }else{
                    $scope.ofertas.ofertas[indice].estado = 'EN PROCESO';
                }

            }else if( oferta.estado === 'EN PROCESO' ){

            }
        }

        $scope.verOferta = ( { oferta } ) => {
            $scope.ofertaSeleccionada = oferta;
        }

        $scope.enviarOfertaActualizada = () => {

            let confirmacion = confirm('¿Seguro de realizar esta acción?, luego no se podra modificar.');

            if( confirmacion ){
                let data = {
                    cantidad_alterada: $scope.cantidad_alterada,
                    nueva_cantidad: $scope.cantidad_alterada === 'No' ? $scope.nueva_cantidad : $scope.ofertaSeleccionada.cantidad,
                    valor_alterado: $scope.valor_alterado,
                    nuevo_valor: $scope.valor_alterado === 'No' ? $scope.nuevo_valor : $scope.ofertaSeleccionada.valor_unitario,
                    nuevo_stock: $scope.nuevo_stock,
                    id_oferta: $scope.ofertaSeleccionada.id,
                    nuevo_estado: 'ACEPTADO',
                    id_producto: $scope.ofertas.id,
                    metodo_pago: $scope.metodo_pago,
                    metodo_envio: $scope.metodo_envio,
                    valor_envio: $scope.valor_envio
                }

                reportService.enviarOfertaActualizadaInclusionProductiva( data ).then( ( { data } ) => {

                    socketService.emit('actualizarNotificacionesInterecesCompra', $scope.ofertaSeleccionada.id_user);

                    $scope.ofertas = data;
                    $scope.stock_actual = data.stocks[data.stocks.length-1].stock;
                    $scope.unidad = data.tipo_producto.unidad.nombre;
                    $('#modal_oferta').modal('hide');

                }, ( error ) => {

                    // console.log(error)

                });
            }

        }

});