var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoInclusionProductivaIntencionesCompraController',
    function ($scope, $rootScope, socketService, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.ofertas = [];

        const socket = socketService.io();

        $scope.api = reportService.api();

        $scope.obtenerOfertas = () => {
            reportService.consultarMisOfertasInclusionProductiva(  ).then( ( { data } ) => {
                $scope.ofertas = data;
    
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.obtenerOfertas();

        socket.on("actualizarNotificacionesInterecesCompra", function ( ) {
            $scope.obtenerOfertas();
        });

        $scope.verInformacion = ( { oferta } ) => {
            $rootScope.restarNotificacionesInterecesCompraInclusionProductiva( oferta );
        }

        $scope.mensajeNoRecibido = ( ) => {
            alert('Si aun no ha recibido el producto, por favor comuníquese con el vendedor del mismo.');
        }

        $scope.marcarRecibido = ( { oferta } ) => {

            // if(navigator.geolocation){
            //     alert('Geolocalización no es soportada por tú navegador, por favor actualizalo o cambia de navegador.');
            //     return;
            // }else{

            let confirmacion = confirm('¿Ya ha recibido el producto?');

            if( confirmacion ) {
                navigator.geolocation.getCurrentPosition( position => {

                    let data = {
                        latitude: position.coords.latitude,
                        longitude: position.coords.longitude,
                        oferta: oferta.id
                    };

                    console.log(oferta);

                    reportService.actualizarOfertaCompraRecibidaInclusionProductiva( data ).then( ( { data } ) => {
                        console.log(data)
                        $scope.ofertas = data;
                    }, ( error ) => {
                        // if(error.status == 401){
                        //     authService.logout();
                        // }
                    });

                }, () => {
                    alert('Error, no es posible obtener su ubicación.');
                });
            }
            // }
             
        }

});
