var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoInclusionProductivaCategoriasController',
    function ($scope, $rootScope, socketService, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.categorias = [];
        $scope.categoria = '';

        const socket = socketService.io();

        $scope.categorias = () => {
            reportService.obtenerCategoriasInclusionProductiva(  ).then( ( { data } ) => {
                $scope.categorias = data;
            }, ( error ) => {
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.categorias();

        $scope.nuevaCategoria = () => {
            reportService.registrarCategoriaInclusionProductiva( { nombre: $scope.categoria } ).then( ( { data } ) => {
                alert('Categoria registrada correctamente.');
                $scope.categorias = data;
                $scope.categoria = '';
            }, ( error ) => {
                if(error.status == 422){
                    alert('El nombre es obligatorio');
                }
            });
        }

        $scope.editarCategoria = ({ categoria }) => {
            let categoria_modificada = prompt("Ingrese la categoria.");
            
            if ( categoria_modificada != null ) {
                let data = {
                    ...categoria,
                    categoria_modificada
                }
            
                reportService.editarCategoriaInclusionProductiva( data ).then( ( { data } ) => {
                    alert('Categoria modificada correctamente.');
                    $scope.categorias = data;
                }, ( error ) => {
                    if(error.status == 422){
                        alert('El nombre es obligatorio');
                    }
                });
            }

        }

 

});
