var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoDetalleCompraController',
    function ($scope, reportService,userService, socketService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.autorizado=localStorage.getItem("satellizer_token");

        $scope.api = reportService.api();

        const id_producto = $routeParams.id;

        $scope.cantidad = 0;
        $scope.valorCompra = 0;

        reportService.obtenerProducto( id_producto ).then( ( { data } ) => {
            $scope.producto = data;

            $scope.img = data.tipo_producto.imagenes[0];

            $scope.imgs = [];

            data.tipo_producto.imagenes.map( (imagen, index) => {
                if(index > 0){
                    $scope.imgs = [ ...$scope.imgs, imagen ];
                }
            })
        }, ( error ) => {
            if(error.status == 401){
                authService.logout();
            }
        });


        $scope.ofertar = () => {

            if($scope.cantidad < 1) {
                alert( 'Cantidad ingresada no valida.' );
            }else{
                const oferta = {
                    cantidad: $scope.cantidad,
                    valor_unitario: $scope.producto.stocks[$scope.producto.stocks.length - 1].valor_stock,
                    valor_total: $scope.cantidad * $scope.producto.stocks[$scope.producto.stocks.length - 1].valor_stock,
                    id_producto: $scope.producto.id,
                    id_municipio_origen: $scope.producto.id_municipio
                }
    
                let confirmar = confirm('¿La información de la oferta es correcta?');
    
                if( confirmar ){
                    reportService.realizarOferta( oferta ).then( ( { data: { message, oferta, vendedor } } ) => {
                        alert( message );
                        socketService.emit('notificarOferta', vendedor);
                        $location.path(`/contacto-vendedor/${ oferta }`);
                    }, ( { status, data: { message } } ) => {
                        if( status == 401 ){
                            authService.logout();
                        }else if( status === 500 ) {
                            alert( 'No es posible realizar la oferta en estos momentos, intentelo más tarde.' );
                        }else if( status === 403 ) {
                            alert( message );
                        }
                    });
                }
            }

        }
       
});