var controllerModule = angular.module('PavitaControllers');

controllerModule.controller('mercadoCategoriasProveedoresController',
    function ($scope, $rootScope, socketService, reportService,userService, authService, $routeParams,$uibModal, $location, $interval,$window) {

        $scope.categorias = [];
        $scope.categoria = '';

        const socket = socketService.io();

        $scope.categorias = () => {
            reportService.obtenerCategoriasProveedoresAdministrador(  ).then( ( { data } ) => {
                $scope.categorias = data;
            }, ( error ) => {
                console.log(error)
                // if(error.status == 401){
                //     authService.logout();
                // }
            });
        }

        $scope.categorias();

        $scope.nuevaCategoria = () => {
            reportService.registrarCategoriaProveedores( { nombre: $scope.categoria } ).then( ( { data } ) => {
                alert('Categoria registrada correctamente.');
                $scope.categorias = data;
                $scope.categoria = '';
            }, ( error ) => {
                if(error.status == 422){
                    alert('El nombre es obligatorio');
                }
            });
        }

        $scope.editarCategoria = ({ categoria }) => {
            let categoria_modificada = prompt("Ingrese la categoria.");
            
            if ( categoria_modificada != null ) {
                let data = {
                    ...categoria,
                    categoria_modificada
                }
            
                reportService.editarCategoriaProveedor( data ).then( ( { data } ) => {
                    alert('Categoria modificada correctamente.');
                    $scope.categorias = data;
                }, ( error ) => {
                    if(error.status == 422){
                        alert('El nombre es obligatorio');
                    }
                });
            }

        }

 

});
