/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


/* global angular */

var Pavita = angular.module('Pavita', [
    'ngRoute',
    'ui.bootstrap',
    'PavitaServices',
    'PavitaControllers',
    'satellizer',
    'ngFileUpload',
    'uiGmapgoogle-maps',
    'angular-loading-bar',
    '720kb.datepicker'
]);

Pavita.directive('flexslider', function() {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            $(element).flexslider(scope.$eval(attrs.flexslider));
        }
    };
});


Pavita.config(function($routeProvider, $locationProvider, $authProvider,uiGmapGoogleMapApiProvider,$httpProvider) {
    uiGmapGoogleMapApiProvider.configure({
        key: 'AIzaSyCDvDTMXN915qqVEcTF2eU5uSnzS23T2sI'
    });
    $authProvider.baseUrl='https://mevi.sigadh.com/api';
    $authProvider.loginUrl = '/api/autenticate/login';
    $routeProvider.
            when('/', {
                templateUrl: 'assets/views/mercado-inicio.html',
                controller: 'mercadoInicioController'
            })
            .when('/registro', {
                templateUrl: 'assets/views/mercado-registro.html',
                controller: 'mercadoRegistroController'
            })
            .when('/login', {
                templateUrl: 'assets/views/mercado-login.html',
                controller: 'mercadoLoginController'
            })
            .when('/compra', {
                templateUrl: 'assets/views/mercado-compra.html',
                controller: 'mercadoCompraController'
            })
            .when('/compra/:id', {
                templateUrl: 'assets/views/mercado-detalleCompra.html',
                controller: 'mercadoDetalleCompraController'
            })
            .when('/registrar-producto', {
                templateUrl: 'assets/views/mercado-registrarEditarProducto.html',
                controller: 'mercadoRegistrarEditarProductoController'
            })
            .when('/editar-producto/:id', {
                templateUrl: 'assets/views/mercado-registrarEditarProducto.html',
                controller: 'mercadoRegistrarEditarProductoController'
            })
            .when('/mis-productos', {
                templateUrl: 'assets/views/mercado-misProductos.html',
                controller: 'mercadoMisProductosController'
            })
            .when('/mis-productos/:id', {
                templateUrl: 'assets/views/mercado-detalleMisProductos.html',
                controller: 'mercadoDetalleMisProductosController'
            })
            .when('/contacto-vendedor/:id', {
                templateUrl: 'assets/views/mercado-contactoVendedor.html',
                controller: 'mercadoContactoVendedorController'
            })
            .when('/ubicaciones', {
                templateUrl: 'assets/views/mercado-ubicaciones.html',
                controller: 'mercadoUbicacionesController'
            })
            .when('/ventas', {
                templateUrl: 'assets/views/mercado-ubicaciones.html',
                controller: 'mercadoUbicacionesController'
            })
            .when('/ventas-recibidas', {
                templateUrl: 'assets/views/mercado-ubicaciones.html',
                controller: 'mercadoUbicacionesController'
            })
            .when('/ofertas', {
                templateUrl: 'assets/views/mercado-ofertas.html',
                controller: 'mercadoOfertasController'
            })
            .when('/ofertas/:id', {
                templateUrl: 'assets/views/mercado-ofertasProducto.html',
                controller: 'mercadoOfertasProductoController'
            })
            .when('/perfil', {
                templateUrl: 'assets/views/mercado-perfil.html',
                controller: 'mercadoPerfilController'
            })
            .when('/about', {
                templateUrl: 'assets/views/mercado-about.html',
                controller: 'mercadoAboutController'
            })
            .when('/intenciones-compra', {
                templateUrl: 'assets/views/mercado-intencionesCompra.html',
                controller: 'mercadoIntencionesCompraController'
            })
            .when('/unidades', {
                templateUrl: 'assets/views/mercado-unidades.html',
                controller: 'mercadoUnidadesController'
            })
            .when('/categorias', {
                templateUrl: 'assets/views/mercado-categorias.html',
                controller: 'mercadoCategoriasController'
            })
            .when('/tipo-productos', {
                templateUrl: 'assets/views/mercado-tipoProductos.html',
                controller: 'mercadoTipoProductosController'
            })
            .when('/galeria', {
                templateUrl: 'assets/views/mercado-galeria.html',
                controller: 'mercadoGaleriaController'
            })

            .when('/proveedores', {
                templateUrl: 'assets/views/mercado-proveedores.html',
                controller: 'mercadoProveedoresController'
            })
            .when('/proveedor/:id_proveedor/productos', {
                templateUrl: 'assets/views/mercado-proveedorProductos.html',
                controller: 'mercadoProveedorProductosController'
            })
            .when('/categorias-proveedores', {
                templateUrl: 'assets/views/mercado-categoriasProveedores.html',
                controller: 'mercadoCategoriasProveedoresController'
            })
            .when('/tipo-productos-proveedores', {
                templateUrl: 'assets/views/mercado-tipoProductosProveedores.html',
                controller: 'mercadoTipoProductosProveedoresController'
            })
            .when('/registrar-producto-proveedor', {
                templateUrl: 'assets/views/mercado-registrarEditarProductoProveedor.html',
                controller: 'mercadoRegistrarEditarProductoProveedorController'
            })
            .when('/editar-producto-proveedor/:id', {
                templateUrl: 'assets/views/mercado-registrarEditarProductoProveedor.html',
                controller: 'mercadoRegistrarEditarProductoProveedorController'
            })
            .when('/mis-productos-proveedor', {
                templateUrl: 'assets/views/mercado-misProductosProveedor.html',
                controller: 'mercadoMisProductosProveedorController'
            })
            .when('/carrito', {
                templateUrl: 'assets/views/mercado-carrito.html',
                controller: 'mercadoCarritoController'
            })
            .when('/contacto-proveedor/:id', {
                templateUrl: 'assets/views/mercado-contactoProveedor.html',
                controller: 'mercadoContactoProveedorController'
            })
            .when('/intenciones-compra/proveedores', {
                templateUrl: 'assets/views/mercado-intencionesCompraProveedores.html',
                controller: 'mercadoIntencionesCompraProveedoresController'
            })
            .when('/proveedor/ofertas/:id', {
                templateUrl: 'assets/views/mercado-ofertasProveedor.html',
                controller: 'mercadoOfertasProveedorController'
            })
            .when('/listado-proveedores', {
                templateUrl: 'assets/views/mercado-listadoProveedores.html',
                controller: 'mercadoListadoProveedoresController'
            })


            .when('/inclusion-productiva/compra', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-compra.html',
                controller: 'mercadoInclusionProductivaCompraController'
            })
            .when('/inclusion-productiva/compra/:id', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-detalleCompra.html',
                controller: 'mercadoInclusionProductivaDetalleCompraController'
            })
            .when('/inclusion-productiva/registrar-producto', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-registrarEditarProducto.html',
                controller: 'mercadoInclusionProductivaRegistrarEditarProductoController'
            })
            .when('/inclusion-productiva/editar-producto/:id', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-registrarEditarProducto.html',
                controller: 'mercadoInclusionProductivaRegistrarEditarProductoController'
            })
            .when('/inclusion-productiva/mis-productos', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-misProductos.html',
                controller: 'mercadoInclusionProductivaMisProductosController'
            })
            .when('/inclusion-productiva/mis-productos/:id', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-detalleMisProductos.html',
                controller: 'mercadoInclusionProductivaDetalleMisProductosController'
            })
            .when('/inclusion-productiva/contacto-vendedor/:id', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-contactoVendedor.html',
                controller: 'mercadoInclusionProductivaContactoVendedorController'
            })
            .when('/inclusion-productiva/intenciones-compra', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-intencionesCompra.html',
                controller: 'mercadoInclusionProductivaIntencionesCompraController'
            })
            .when('/inclusion-productiva/ofertas/:id', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-ofertasProducto.html',
                controller: 'mercadoInclusionProductivaOfertasProductoController'
            })
            .when('/inclusion-productiva/sesiones', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-sesiones.html',
                controller: 'mercadoInclusionProductivaSesionesController'
            })
            // .when('/inclusion-productiva/sesiones/:id', {
            //     templateUrl: 'assets/views/mercado-inclusionProductiva-detalleSesion.html',
            //     controller: 'mercadoInclusionProductivaDetalleSesionController'
            // })
            .when('/categorias-inclusion', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-categorias.html',
                controller: 'mercadoInclusionProductivaCategoriasController'
            })
            .when('/tipo-productos-inclusion', {
                templateUrl: 'assets/views/mercado-inclusionProductiva-tipoProductos.html',
                controller: 'mercadoInclusionProductivaTipoProductosController'
            })

            .otherwise({
                // redirectTo: '/404',
                templateUrl: 'assets/views/mercado404.html',
            });            
    $locationProvider.html5Mode(true);

})/*.run(['$rootScope','$location','$auth', function ($rootScope, $location, $auth) {
                $rootScope.$on("$routeChangeStart", function (event, next, current) {
                    if (!$auth.isAuthenticated()){ 
                        $location.path('/login');
                    }
                });
            }]);*/