<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('formularios','FormularioVmcPlanInversionController@index');
Route::get('items','FormularioVmcPlanInversionController@items');

Route::get('/', function () {
    return view('welcome');
});
//////////////////////////////////////////
/**
 * SIGADh VV
 */
Route::group(["prefix" => "data"], function(){
    Route::post('forms','RegistroSigadhVvController@store');
});

//////////////////////////////////////////
Route::group(["prefix" => "auth"], function(){
    Route::post('login','AuthenticateController@login');
});

Route::group(["prefix" => "info"], function(){
    Route::get('participantes','ParticipanteController@indexx');
});
/////////////////////////////////////////

Route::get('pass','UserController@pass');

Route::group(['prefix'=>'auth'], function(){
	Route::resource('authenticate','AuthenticateController',['only'=>['index']]);
	Route::post('authenticate','AuthenticateController@authenticate'); //login
});

Route::group(['prefix' => 'ubicaciones'], function(){
	Route::get('all','PavitaUbicacionController@index');
});

Route::group(['prefix' => 'participantes'], function(){
	Route::get('all','ParticipanteController@index');
	Route::get('all2','ParticipanteController@index2');
	Route::get('all3','ParticipanteController@index3');

	Route::get('consultar','ParticipanteController@show');
	Route::get('one','ParticipanteController@showOnlyOne');
});

Route::group(['prefix' => 'fotografias'], function(){
	Route::get('participante','FotografiaController@show');
});
Route::get('actividades','FormularioActividadesController@getDocument');

Route::group(['prefix' => 'formularios'], function(){

	Route::post('actividades','FormularioActividadesController@store');
	Route::post('actividades/anexos','FormularioActividadesController@anexos');

	Route::post('actividades/grupales','ActividadVirtualGrupalController@store');
	Route::post('actividades/grupales/anexos','ActividadVirtualGrupalController@anexos');
	Route::get('reporte/actividades/grupales','ActividadVirtualGrupalController@index');



	Route::get('reporte/actividades','FormularioActividadesController@index');
	Route::get('reporte/actividades/participante','FormularioActividadesController@show');
	Route::get('documento','FormularioActividadesController@getDocumento');

	Route::post('fotografias','FotografiaController@store');

	// formulario Caracterizacion Proyecto Productivo
	Route::post('proyectoProductivo/caracterizacion','FormularioPpCaracterizacionController@store');
	Route::get('proyectoProductivo/caracterizacion/all','FormularioPpCaracterizacionController@index');
	Route::get('proyectoProductivo/caracterizacion/one','FormularioPpCaracterizacionController@show');

	// formulario plan de inversion proyecto productivo
	Route::post('proyectoProductivo/planInversion','FormularioPpPlanInversionController@store');
	Route::get('proyectoProductivo/planesInversion/all','FormularioPpPlanInversionController@index');

	// formulario caracterizacion social y comunitario
	Route::post('fortalecimientoSocialComunitario/caracterizacionEntrada','FormularioCaracterizacionEntradaController@store');

	// formulario plan de inversion huerta casera seguridad alimentaria
	Route::get('seguridad-alimentaria/plan-inversion/huerta-casera/all','FormularioSaPlanInversionHuertaCaseraController@index');
	Route::get('seguridad-alimentaria/plan-inversion/huerta-casera/one','FormularioSaPlanInversionHuertaCaseraController@show');

	// formulario plan de inversion huerta comunitaria seguridad alimentaria
	Route::get('seguridad-alimentaria/plan-inversion/huerta-comunitaria/all','FormularioSaPlanInversionHuertaComunitariaController@index');
	Route::get('seguridad-alimentaria/plan-inversion/huerta-comunitaria/one','FormularioSaPlanInversionHuertaComunitariaController@show');

	// formulario plan de inversion vivir mi casa
	Route::get('vivir-mi-casa/plan-inversion/all','FormularioVmcPlanInversionController@index');
	Route::get('vivir-mi-casa/plan-inversion/one','FormularioVmcPlanInversionController@show');



});

Route::group(['prefix' => 'reportes'], function(){
	//Protecto Productivo
	Route::get('proyecto-productivo/caracterizacion/general','FormularioPpCaracterizacionController@reporteGeneral');
	Route::get('proyecto-productivo/plan-inversion/general','FormularioPpPlanInversionController@reporteGeneral');

	//Seguridad Alimentaria
	Route::get('seguridad-alimentaria/plan-inversion/huerta-casera','FormularioSaPlanInversionHuertaCaseraController@reporteGeneral');
	Route::get('seguridad-alimentaria/plan-inversion/huerta-comunitaria','FormularioSaPlanInversionHuertaComunitariaController@reporteGeneral');

	//vivir mi casa
		//plan de inversion
	Route::get('vivir-mi-casa/plan-inversion','FormularioVmcPlanInversionController@reporteGeneral');


	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Reporte Actividades Virtuales
	Route::get('actividades-virtuales','FormularioActividadesController@reporteGeneral');

});

Route::group(['prefix'=>'usr'], function(){
	Route::get('nombre','UserController@nombre');
	// Route::post('registrar','UserController@registrar'); //crear asesor
	// Route::post('regintegrante','UserController@registrarIntegrante'); //agregar integrante a nucleo
	// Route::patch('cpass','UserController@cpass');
});

// Route::group(['prefix'=>'nucleo'],function(){
// 	Route::get('all','vnController@getNucleos'); //Lista de todos lo nucleos
// 	Route::get('integrantes','UserController@integrantesNucleo'); //Lista integrantes de un nucleo
// 	Route::get('infoid','vnController@infoNucleoId'); //Info General de un nucleo
// });

// Route::group(['prefix'=>'vivienda'],function(){
// 	Route::get('all','vnController@getViviendas'); //Lista todas las viviendas
// 	Route::get('nucleos','vnController@nucleosVivienda'); //Lista los nucleos de una vivienda
// });

// Route::group(['prefix'=>'caracterizacion'],function(){
// 	Route::post('local',	 'DimNucleoController@localizacion');
// 	Route::post('coords',	 'DimNucleoController@asignarCoordenadas');
// 	Route::post('dimhabitat','DimNucleoController@CaracterizacionHabitat');
// 	Route::post('dimtyc',	 'DimNucleoController@CaracterizacionDimTerritorial');
// 	Route::post('ingresos',	 'DimNucleoController@CaracterizacionIngresos');
// 	Route::post('anexotyc',	 'DimIntegranteController@CaracterizacionAnexoUrbana');
// 	Route::post('salud',	 'DimIntegranteController@CaracterizacionDimSalud');
// 	Route::post('educacion', 'DimIntegranteController@CaracterizacionDimEducacion');
// 	Route::post('economia',	 'DimIntegranteController@CaracterizacionDimEconomia');
// });

// Route::group(['prefix'=>'reportes'],function(){
// 	Route::get('localizacion',	'vnController@reporteLocalizacion');
// 	Route::get('habitabilidad',	'vnController@reporteDimHabitat');
// 	Route::get('educacion',		'vnController@reporteDimEducacion');
// 	Route::get('salud',			'vnController@reporteDimSalud');
// 	Route::get('economia',		'vnController@reporteDimEconomia');
// 	Route::get('dimtyc',		'vnController@reporteDimTyC');
// 	Route::get('monitor',		'vnController@coordsViviendas');
// 	Route::get('general',		'vnController@reporteGeneralC');
// 	Route::get('identificacion','vnController@reporteIdentificacion');
// });
