<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('accesos','UserController@accesos');

Route::get('departamentos/{tipo_mercado}','DepartamentoController@index');
Route::get('categorias','CategoriaController@index');
Route::get('unidades','UnidadController@index');


Route::group(["prefix" => "autenticate"], function(){
    Route::post('login','AuthenticateController@login');
    Route::post('registro','AuthenticateController@registrar');
});

Route::group(["prefix" => "productos"], function(){
    Route::get('','ProductoController@index');
    Route::get('otro','ProductoController@index2');
    Route::get('mis-productos','ProductoController@misProductos');
    Route::get('{id}','ProductoController@show');
    Route::post('nuevo','ProductoController@store');
    Route::post('actualizar','ProductoController@update');
});

Route::group(["prefix" => "ofertas"], function(){
    Route::get('','OfertaController@index');
    Route::get('mis-ofertas','OfertaController@misOfertas');
    Route::get('producto','OfertaController@show');
    Route::post('nueva','OfertaController@store');
    Route::get('informacion-vendedor/{id}','OfertaController@informacionOferta');
    Route::post('actualizar','OfertaController@update');
    Route::get('total','OfertaController@totalOfertas');
    Route::get('realizadas','OfertaController@ofertasRealizadas');
    Route::get('respuestas','OfertaController@respuestas');
    Route::post('visado','OfertaController@visado');
    Route::post('compra-recibida','OfertaController@compraRecibida');
});

Route::group(["prefix" => "imagenes"], function(){
    Route::get('{id}','ImagenesProductoController@show');
});

Route::group(["prefix" => "usuario"], function(){
    Route::get('','UserController@show');
    Route::post('actualizacion','UserController@update');
});

Route::post('filtros/publicos','FiltroController@filtroPublico');
Route::post('filtros/privados','FiltroController@filtroPrivado');
Route::post('filtros/proveedores/publicos','FiltroController@filtroProveedoresPublicos');
Route::post('filtros/proveedores/privados','FiltroController@filtroProveedoresPrivados');
Route::post('filtros/proveedores/productos','FiltroController@filtroProductosProveedores');

Route::group(["prefix" => "ubicaciones"], function(){
    Route::get('','UbicacionController@index');
    Route::get('ventas','UbicacionController@ventas');
    Route::get('recibidos','UbicacionController@recibidos');
    // Route::get('{id}','ImagenesProductoController@show');
});

Route::group(["prefix" => "unidades"], function(){
    Route::get('','UnidadController@index');
    Route::post('nueva','UnidadController@store');
    Route::post('','UnidadController@update');
});

Route::group(["prefix" => "categorias"], function(){
    Route::get('','CategoriaController@index');
    Route::get('dos','CategoriaController@privateIndex');
    Route::post('nueva','CategoriaController@store');
    Route::post('','CategoriaController@update');
});

Route::group(["prefix" => "tipo-productos"], function(){
    Route::get('','TipoProductoController@index');
    Route::post('nueva','TipoProductoController@store');
    Route::post('','TipoProductoController@update');
});

Route::group(["prefix" => "reportes"], function(){
    Route::get('productos','ReporteController@productosRegistrados');
    Route::get('ventas','ReporteController@ventasRegistradas');
    Route::get('proveedores','ReporteController@proveedores');
});

Route::group(["prefix" => "proveedores"], function(){
    Route::get('','UserController@proveedores');
    Route::get('listado','UserController@listadoProveedores');
    Route::post('cambiarPassword','UserController@cambiarPassword');
    Route::get('publicos','UserController@proveedoresPublicos');

    Route::group(["prefix" => "stock"], function(){
        Route::post('nuevo','StockProveedorController@store');
    });

    Route::group(["prefix" => "categorias"], function(){
        Route::get('','CategoriaProveedorController@index');
        Route::get('privado','CategoriaProveedorController@privateIndex');
        Route::get('listadoAdministrador','CategoriaProveedorController@listadoAdministrador');
        Route::post('nueva','CategoriaProveedorController@store');
        Route::post('','CategoriaProveedorController@update');
    });

    Route::group(["prefix" => "tipo-productos"], function(){
        Route::get('','TipoProductoProveedorController@index');
        Route::post('nueva','TipoProductoProveedorController@store');
        Route::post('','TipoProductoProveedorController@update');
    });

    Route::group(["prefix" => "productos"], function(){
        Route::get('','ProductoProveedorController@index');
        Route::get('otro','ProductoProveedorController@index2');
        Route::get('mis-productos','ProductoProveedorController@misProductos');
        Route::get('{id}','ProductoProveedorController@show');
        Route::post('nuevo','ProductoProveedorController@store');
        Route::post('actualizar','ProductoProveedorController@update');
    });

    Route::group(["prefix" => "carrito"], function(){
        Route::get('','CarritoController@index');
        Route::get('notificaciones','CarritoController@notificaciones');
        Route::get('enviados','CarritoController@carritosEnviados');
        Route::get('{id}','CarritoController@show');
        Route::post('nuevo','CarritoController@store');
        Route::post('actualizar','CarritoProductoController@update');
        Route::post('eliminar','CarritoProductoController@delete');
    });

    Route::group(["prefix" => "ofertas"], function(){
        Route::get('','OfertaProveedorController@index');
        Route::get('productos','OfertaProveedorController@show');
        Route::get('total','OfertaProveedorController@totalOfertas');
        Route::post('nueva','OfertaProveedorController@store');
        Route::post('actualizar','OfertaProveedorController@update');
    });

    Route::group(["prefix" => "reportes"], function(){
        // Route::get('productos','ReporteController@productosRegistrados');
        Route::get('ventas','ReporteController@ventasProveedoresRegistradas');
    });

});



Route::group(["prefix" => "inclusionProductiva/productos"], function(){
    Route::get('','ProductoInclusionProductivaController@index');
    Route::get('otro','ProductoInclusionProductivaController@index2');
    Route::get('mis-productos','ProductoInclusionProductivaController@misProductos');
    Route::get('{id}','ProductoInclusionProductivaController@show');
    Route::post('nuevo','ProductoInclusionProductivaController@store');
    Route::post('actualizar','ProductoInclusionProductivaController@update');
});

Route::group(["prefix" => "inclusionProductiva/ofertas"], function(){
    Route::get('','OfertaInclusionProductivaController@index');
    Route::get('mis-ofertas','OfertaController@misOfertas');
    Route::get('producto','OfertaInclusionProductivaController@show');
    
    /// OK
    Route::post('nueva','OfertaInclusionProductivaController@store');
    Route::get('informacion-vendedor/{id}','OfertaInclusionProductivaController@informacionOferta');
    Route::get('realizadas','OfertaInclusionProductivaController@ofertasRealizadas');
    Route::post('compra-recibida','OfertaInclusionProductivaController@compraRecibida');
    ///
    
    
    Route::post('actualizar','OfertaInclusionProductivaController@update');
    Route::get('total','OfertaController@totalOfertas');
    
    Route::get('respuestas','OfertaController@respuestas');
    Route::post('visado','OfertaInclusionProductivaController@visado');
    
});

Route::group(["prefix" => "inclusionProductiva/sesiones"], function(){
    Route::get('','SesionController@index');
    Route::get('publicas','SesionController@indexPublico');
    Route::post('nueva','SesionController@store');
    Route::post('','SesionController@update');
    Route::post('eliminar','SesionController@destroy');
});

Route::group(["prefix" => "inclusionProductiva/categorias"], function(){
    Route::get('','CategoriaInclusionProductivaController@index');
    Route::get('dos','CategoriaInclusionProductivaController@privateIndex');
    Route::post('nueva','CategoriaInclusionProductivaController@store');
    Route::post('','CategoriaInclusionProductivaController@update');
});

Route::group(["prefix" => "inclusionProductiva/imagenes"], function(){
    Route::get('{id}','ImagenesProductoInclusionProductivaController@show');
});

Route::group(["prefix" => "inclusionProductiva/tipo-productos"], function(){
    Route::get('','TipoProductoInclusionProductivaController@index');
    Route::post('nueva','TipoProductoInclusionProductivaController@store');
    Route::post('','TipoProductoInclusionProductivaController@update');
});

Route::group(["prefix" => "inclusionProductiva/reportes"], function(){
    // Route::get('productos','ReporteController@productosRegistrados');
    Route::get('ventas','ReporteController@ventasInclusionProductivaRegistradas');
});

Route::post('inclusionProductiva/filtros/publicos','FiltroController@filtroPublicoInclusionProductiva');
Route::post('inclusionProductiva/filtros/privados','FiltroController@filtroPrivadoInclusionProductiva');
