<?php

namespace App;

use JWTAuth;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;


class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $fillable = [
        'id', 'cedula','primer_nombre','segundo_nombre','primer_apellido','segundo_apellido','telefono','email', 'direccion', 'latitude',
        'longitude', 'password', 'estado', 'id_municipio', 'zona', 'id_role', 'nombre_almacen', 'nit', 'rut', 'descripcion_almacen', 'organizacion'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'id_role', 'password','estado','created_at','updated_at', 'deleted_at'
    ];


    public function getAuthenticatedUser(){
        try {
            if (! $user = JWTAuth::parseToken()->authenticate()) {
                return response()->json(['user_not_found'], 404);
            }
        } catch (Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {
            return response()->json(['token_expired'], $e->getStatusCode());
        } catch (Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {
            return response()->json(['token_invalid'], $e->getStatusCode());
        } catch (Tymon\JWTAuth\Exceptions\JWTException $e) {
            return response()->json(['token_absent'], $e->getStatusCode());
        }

        return $user;
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function municipio(){
        return $this->belongsTo(Municipio::class, 'id_municipio');
    }

    public function participante(){
        return $this->HasOne(Participante::class, 'id_user');
    }
}
