<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TipoProductoProveedor extends Model
{
    protected $table = 'tipo_producto_proveedor';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'nombre', 'id_categoria', 'id_unidad'
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'created_at', 'updated_at',
    ];

    /**
     * Relaciones Tabla
     */

    // public function productos(){
    //     return $this->hasMany(Producto::class, 'id_tipo_producto');
    // }

    public function imagenes(){
        return $this->hasMany(ImagenesProducto::class, 'id_tipo_producto');
    }

    public function unidad(){
        return $this->belongsTo(Unidad::class, 'id_unidad');
    }

    public function categoria_proveedor(){
        return $this->belongsTo(CategoriaProveedor::class, 'id_categoria');
    }

    public function productos_proveedores(){
        return $this->hasMany(ProductoProveedor::class, 'id_tipo_producto');
    }

}
