<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductoProveedor extends Model
{
    protected $table = 'productos_proveedores';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'producto', 'descripcion', 'id_categoria', 'unidad_venta', 'stock_actual', 'latitude', 'longitude', 
        'id_municipio', 'zona', 'id_user',
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'created_at', 'updated_at',
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    public function categoria(){
        return $this->belongsTo(CategoriaProveedor::class, 'id_categoria');
    }

    public function stocks_proveedores(){
        return $this->hasMany(StockProveedor::class, 'id_producto');
    }

    public function imagenes(){
        return $this->hasMany(ImagenesProducto::class, 'id_producto');
    }

    public function usuario(){
        return $this->belongsTo(User::class, 'id_user');
    }

    public function ofertas(){
        return $this->hasMany(OfertaProveedor::class, 'id_producto');
    }

    public function tipoProductoProveedor(){
        return $this->belongsTo(TipoProductoProveedor::class, 'id_tipo_producto');
    }

    public function municipio(){
        return $this->belongsTo(Municipio::class, 'id_municipio');
    }
}
