<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductoInclusionProductiva extends Model
{
    protected $table = 'inclusionProductiva_productos';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'id_tipo_producto', 'descripcion', 'stock_actual', 'latitude', 'longitude', 
        'id_municipio', 'zona', 'id_user',
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'created_at', 'updated_at',
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    public function stocks(){
        return $this->hasMany(StockInclusionProductiva::class, 'id_producto');
    }

    public function imagenes(){
        return $this->hasMany(ImagenesProductoInclusionProductiva::class, 'id_producto');
    }

    public function usuario(){
        return $this->belongsTo(User::class, 'id_user');
    }

    public function ofertas(){
        return $this->hasMany(OfertaInclusionProductiva::class, 'id_producto');
    }

    public function tipoProducto(){
        return $this->belongsTo(TipoProductoInclusionProductiva::class, 'id_tipo_producto');
    }

    public function municipio(){
        return $this->belongsTo(Municipio::class, 'id_municipio');
    }
}
