<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OfertaProveedor extends Model
{
    protected $table = 'ofertas_proveedores';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'cantidad', 'estado', 'valor_unitario', 'valor_total', 'cantidad_venta', 'valor_unitario_venta',
        'valor_total_venta', 'id_municipio_origen',
        'id_municipio_destino', 'direccion_destino', 'id_user', 'id_producto', 'id_stock', 'metodo_pago',
        'metodo_envio', 'valor_envio', 'visto', 'latitude', 'longitude', 'fecha_recibido', 'id_carrito_producto', 'created_at', 
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'updated_at', 'deleted_at'
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    // public function stoks(){
    //     return $this->hasMany(Stock::class, 'id_producto');
    // }

    // public function imagenes(){
    //     return $this->hasMany(ImagenesProducto::class, 'id_producto');
    // }

    public function municipioOrigen(){
        return $this->belongsTo(Municipio::class, 'id_municipio_origen');
    }

    public function municipioDestino(){
        return $this->belongsTo(Municipio::class, 'id_municipio_destino');
    }

    public function usuario(){
        return $this->belongsTo(User::class, 'id_user');
    }

    public function productoProveedor(){
        return $this->belongsTo(ProductoProveedor::class, 'id_producto');
    }
}
