<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OfertaInclusionProductiva extends Model
{
    protected $table = 'inclusionProductiva_ofertas';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'cantidad', 'estado', 'valor_unitario', 'valor_total', 'cantidad_venta', 'valor_unitario_venta',
        'valor_total_venta', 'id_municipio_origen',
        'id_municipio_destino', 'direccion_destino', 'id_user', 'id_producto', 'id_stock', 'metodo_pago',
        'metodo_envio', 'valor_envio', 'visto', 'latitude', 'longitude', 'fecha_recibido', 'created_at', 
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'updated_at', 'deleted_at'
    ];

    /**
     * Relaciones Tabla Departamentos
     */

    // public function stoks(){
    //     return $this->hasMany(Stock::class, 'id_producto');
    // }

    // public function imagenes(){
    //     return $this->hasMany(ImagenesProducto::class, 'id_producto');
    // }

    public function municipioOrigen(){
        return $this->belongsTo(Municipio::class, 'id_municipio_origen');
    }

    public function municipioDestino(){
        return $this->belongsTo(Municipio::class, 'id_municipio_destino');
    }

    public function usuario(){
        return $this->belongsTo(User::class, 'id_user');
    }

    public function producto(){
        return $this->belongsTo(ProductoInclusionProductiva::class, 'id_producto');
    }
}
