<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Municipio extends Model
{
    protected $table = 'municipios';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'nombre', 'id_departamento'
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'id_departamento', 'created_at', 'updated_at',
    ];

    public function departamento(){
        return $this->belongsTo(Departamento::class, 'id_departamento');
    }

    public function productos(){
        return $this->hasMany(Producto::class, 'id_municipio');
    }

    public function productosProveedores(){
        return $this->hasMany(ProductoProveedor::class, 'id_municipio');
    }

    public function proveedores(){
        return $this->hasMany(User::class, 'id_municipio');
    }

    public function productosInclusion(){
        return $this->hasMany(ProductoInclusionProductiva::class, 'id_municipio');
    }
}
