<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MenuTipo extends Model
{
    protected $table = 'menu_tipos';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'titulo'
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'id', 'created_at', 'updated_at',
    ];

    /**
     * Relaciones Tabla
     */

    // public function productos(){
    //     return $this->hasMany(Producto::class, 'id_tipo_producto');
    // }

    public function opciones(){
        return $this->hasMany(MenuOpcion::class, 'id_menu_tipos');
    }

}
