<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MenuOpcion extends Model
{
    protected $table = 'menu_opciones';

    /**
     * Atributos asignable dentro del registro
     *
     * @var array
     */
    protected $fillable = [
        'id', 'titulo', 'path', 'icon', 'notificaciones', 'id_menu_tipos'
    ];

    /**
     * Atributos que permanecen ocultos por seguridad y que solo son accedidos por
     *  aquellos que lo necesiten y tengan los permisos
     *
     * @var array
     */
    protected $hidden = [
        'id_menu_tipos', 'created_at', 'updated_at',
    ];

    /**
     * Relaciones Tabla
     */

    public function tipoMenu(){
        return $this->belongsTo(MenuTipo::class, 'id_menu_tipos');
    }

}
