<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class TipoProductoProveedoresFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function rules()
    {
        $rules = [
            "nombre"        => 'required|string',
            "id_categoria"  => 'required|integer',
            "id_unidad"     => 'required|integer',
            // 'id_municipio' => 'required|integer',
            // "imagenes" => 'required|array',
            // "imagenes"      => 'required|array',
            // "imagenes.*"    => 'image|mimes:jpeg,png,jpg|max:2048',
        ];
  
        return $rules;
    }

    /**
    * Configure the validator instance.
    *
    * @param Validator  $validator
    * @return void
    */
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json($validator->errors(), 422));

    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'nombre.required'       => 'EL Nombre es requerido',
            'id_categoria.required' => 'La categoria de medida es requerida',
            'id_categoria.integer'  => 'La categoria de medida es requerida',
            'id_unidad.required'    => 'La unidad de medida es requerida',
            'id_unidad.integer'     => 'La unidad de medida es requerida',
            // 'imagenes.required'     => 'La imagen es requerida'
            // 'descripcion.required' => 'La descripción es requerida',
            // 'precio.required' => 'El precio es requerido',
        ];
    }
}
