<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class RegistrarUsuarioFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_role'               => 'required',
            "primer_nombre"         => 'required|string',
            "primer_apellido"       => 'required|string',
            "cedula"                => 'required|unique:users|string|min:5',
            "telefono"              => 'required|integer',
            "email"                 => 'email|unique:users|confirmed',
            "password"              => 'required|min:8|string|confirmed',
            'id_municipio'          => 'required|integer',
            'direccion'             => 'required|string',
            'nombre_almacen'        => 'required_if:id_role,6|string',
            'nit'                   => 'string',
            'descripcion_almacen'   => 'required_if:id_role,6|string',
            'rut'                   => 'required_if:id_role,6|string',
            'organizacion'          => 'required'
        ];
    }

    /**
    * Configure the validator instance.
    *
    * @param Validator  $validator
    * @return void
    */
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json($validator->errors(), 422));

    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'primer_nombre.required'    => 'EL Nombre es requerido',
            'primer_nombre.string'      => 'EL Nombre debe ser alfanumerico',
            'primer_apellido.required'  => 'El Apellido es requerido',
            'primer_apellido.string'    => 'El Apellido debe ser alfanumerico',
            'cedula.required'           => 'El numero de documento es requerido',
            'cedula.unique'             => 'El numero de documento ya existe',
            'cedula.integer'            => 'El documento debe ser numerico',
            'cedula.min'                => 'El documento debe ser minimo de 5 caracteres',
            'telefono.required'         => 'El Telefono es requerido',
            'telefono.integer'          => 'El Telefono debe ser numerico',
            'email.email'               => 'El formato del Email no es valido',
            'email.unique'              => 'El Email ya existe',
            'email.confirmed'           => 'Los Emails no coinciden',
            'password.required'         => 'La Contraseña es requerida',
            'password.min'              => 'La Contraseña debe ser minimo de 8 caracteres',
            'password.confirmed'        => 'Las Contraseñas no coinciden',
            'id_municipio.required'     => 'El Municipio es requerido',
            'id_municipio.integer'      => 'El Municipio es requerido',
            'direccion.required'        => 'La dirección es requerida',
            'direccion.string'          => 'La Dirección debe ser alfanumerica',
            'nombre_almacen.required'   => 'El nombre del almacen es requerido',
            'nit.required'              => 'El nit es requerido',
        ];
    }
}
