<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ProductoFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function rules()
    {
        $rules = [
            "producto"      => 'required',
            "descripcion"   => 'required',
            "id_categoria"  => 'required|integer',
            "unidad_venta"  => 'required',
            "precio"        => 'required|integer',
            "cantidad"      => 'required|integer',
            'latitude'      => 'string',
            'longitude'     => 'string',
            'descuento'     => 'required|integer|between:0,20'
        ];
  
        return $rules;
    }

    /**
    * Configure the validator instance.
    *
    * @param Validator  $validator
    * @return void
    */
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json($validator->errors(), 422));

    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            // 'nombre.required' => 'EL Nombre es requerido',
            // 'id_unidad.required' => 'La unidad de medida es requerida',
            // 'id_unidad.integer' => 'La unidad de medida es requerida',
            // 'descripcion.required' => 'La descripción es requerida',
            // 'precio.required' => 'El precio es requerido',
        ];
    }
}
