<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class CategoriaUnidadFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function rules()
    {
        $rules = [
            "nombre"  => 'required',
        ];
  
        return $rules;
    }

    /**
    * Configure the validator instance.
    *
    * @param Validator  $validator
    * @return void
    */
    protected function failedValidation(Validator $validator){

        throw new HttpResponseException(response()->json($validator->errors(), 422));

    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'nombre.required'       => 'EL Nombre es requerido'
        ];
    }
}
