<?php

namespace App\Http\Controllers;

use JWTAuth;
use DateTime;
use App\User;
use App\Folio;
use App\Nucleo;
use App\Integrante;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuthExceptions\JWTException;

use App\Http\Requests\ActualizacionUsuarioFormRequest;

class UserController extends Controller
{

    public function __construct(){
           // Apply the jwt.auth middleware to all methods in this controller
           // except for the authenticate method. We don't want to prevent
           // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['pass', 'documento', 'proveedoresPublicos','accesos']]);
        $this->messages = array(
                'required'      =>'el campo :attribute es obligatorio.',
                'email'         =>'el :attribute debe ser válido.',
                'email.unique'  =>'El correo debe ser único.',
                'confirmed'     =>'The :attribute have to be equal.'
            );

   }


   public function accesos(){
    //    return $users = User::where('id_role', 6)->get();

    //    foreach ($users as $key => $user) {
    //         $user->password = Hash::make("fest-".$user['cedula']);
    //         $user->save();
    //    }

    //    return "Accesos actualizados";
   }


    public function show(){
        return User::where('id', auth()->user()->id)
                ->with(['municipio' => function($municipio){
                    $municipio->with('departamento');
                }])->first();
    }

    public function update(ActualizacionUsuarioFormRequest $request){
        $data = $request->all();

        if( auth()->user()->id_role == 7){

            return response()->json([
                'susses' => false,
                'message' => 'No es posible actualizar esta información.',
                'codigo' => 403
            ], 403);

        }

        $user = User::where('id', auth()->user()->id)->first();

        $user['primer_nombre'] = $data['primer_nombre'];
        $user['segundo_nombre'] = $data['segundo_nombre'];
        $user['primer_apellido'] = $data['primer_apellido'];
        $user['segundo_apellido'] = $data['segundo_apellido'];
        $user['cedula'] = $data['cedula'];
        $user['telefono'] = $data['telefono'];
        $user['direccion'] = $data['direccion'];

        if( isset($data['email']) ){
            $user['email'] = $data['email'];
        }

        $user['id_municipio'] = $data['id_municipio'];

        if( isset($data['password']) ){
            $user['password'] = Hash::make( $data['password'] );
        }

        $user->save();

        return response()->json([
            'susses' => true,
            'message' => 'Información actualizada correctamente',
            'codigo' => 200
        ], 200);

    }

    public function pass(){
        $users = User::all();
        foreach ($users as $user){
            $user->password = Hash::make($user->password);
            $user->save();
        }
        return $users;
    }

    public function nombre(){
        // $user=(new User)->getAuthenticatedUser();
        // $nombre=$user['primerNombre'];
        // if(isset($user['segundoNombre'])){
        //     $nombre=$nombre.' '.$user['segundoNombre'];
        // }
        // $nombre=$nombre.' '.$user['primerApellido'].' '.$user['segundoApellido'];
        $nombre=auth()->user()->nombre.' '.auth()->user()->apellido;
        return $nombre;
    }

    public function registrar(Request $request){
        //$user= new User;
        if((new User)->getAuthenticatedUser()->adminUser()){
            $post_data = Input::all();
            $rules = array(
                'cedula'            =>'required|numeric|unique:users,cedula',
                'tel'               =>'required|numeric',
                'email'             =>'required|email|unique:users,email',
                'primerNombre'      =>'required|string',
                'segundoNombre'     =>'string',
                'primerApellido'    =>'required|string',
                'segundoApellido'   =>'required|string',
                'password'          =>'required|string'
            );
            
            $validate = Validator::make($post_data, $rules, $this->messages);
            if ($validate->passes()) {
                if(User::find($post_data['cedula'])){
                    return Response::make('La cédula ya está registrada',500);
                }
                $charactersM = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $characters  = 'abcdefghijklmnopqrstuvwxyz';

				$pin = mt_rand(100000, 999999)
				    . $charactersM[rand(0, strlen($characters) - 1)]
				    . $characters[rand(0, strlen($characters) - 1)];

				$string = str_shuffle($pin);
                $post_data['password'] = Hash::make($post_data['password']);
                $post_data['habilitado']=1;
                $user=User::create($post_data);
                $user->roles()->attach(1);
                return Response::make('Registro exitoso. Pin: '.$string, 200);
            } else {
                return Response::make($validate->messages(), 500);
            }   
        }
        else{
            return response::make('Usted no está autorizado para realizar esta función',403);
        }
    }

    public function registrarIntegrante(Request $request){
        $user=(new User)->getAuthenticatedUser();
        $rules = array(
                'tipo_documento'    =>'required|string',
                'numero_documento'  =>'required_unless:tipo_documento,No tiene|numeric|unique:integrantes,numero_documento',
                'contacto1'         =>'nullable|numeric',
                'contacto2'         =>'nullable|numeric',
                'parentesco'        =>'required|string',
                'primerNombre'      =>'required|string',
                'segundoNombre'     =>'nullable|string',
                'primerApellido'    =>'required|string',
                'segundoApellido'   =>'nullable|string',
                'fecha_nacimiento'  =>'required|date',
                'sexo'              =>'required|string',
                'se_reconoce'       =>'required|string',
                'religion'          =>'required|string',
                'nacionalidad'      =>'required|string',
                'rlcpd'             =>'required|string',
                'discapacidad'      =>'required|boolean',
                'nucleo_id'         =>'required|numeric',
                'representante'     =>'boolean'
            );
        $post_data=Input::only('tipo_documento','numero_documento','contacto1','contacto2','parentesco','primerNombre','segundoNombre','primerApellido','segundoApellido','fecha_nacimiento','sexo','se_reconoce','nacionalidad','discapacidad','rlcpd','religion','nucleo_id','representante');
        $validate = Validator::make($post_data, $rules, $this->messages);
            if ($validate->passes()){
                $user=(new User)->getAuthenticatedUser();
                if(!Nucleo::find($post_data['nucleo_id'])){
                    return Response::make('El nucleo al que se intenta asociar no fue encontrado',404);
                }
                $post_data['user_cedula']=$user['cedula'];
                $integrante=Integrante::create($post_data);
                if(isset($post_data['representante'])){
                    if($post_data['representante']){
                        $nucleo=Nucleo::find($post_data['nucleo_id']);
                        if(!isset($nucleo['representante_id'])){
                            $nucleo['representante_id']=$integrante['id'];
                            $nucleo->save();
                        }
                    }
                }
                Folio::create(['integrante_id'=>$integrante['id'],'momento'=>'Caracterización','user_cedula'=>$user['cedula'],'habilitado'=>1]);
            }else{
                return Response::make($validate->messages(), 500);
            }
    }

    public function cpass(){
        if(!(new User)->getAuthenticatedUser()->adminUser()){
            return;
        }
        $data=Input::all();
        $user=User::find($data['cedula']);
        $user['password']=Hash::make($data['password']);
        $user->save();
        return response()->json(['message' => 'registro exitoso','pin'=>$user['password']], 200);
    }

    public function integrantesNucleo(){
        $post_data=Input::only('nucleo_id');
        $nucleo=Nucleo::find($post_data['nucleo_id']);
        if(!isset($nucleo)){
            return Response::make('Nucleo no encontrado',404);
        }
        $datos['integrantes']=$nucleo->integrantes()->get();
        foreach ($datos['integrantes'] as $in) {
            $fn =new DateTime($in['fecha_nacimiento']);
            $hoy=new DateTime();
            $in['edad']=($hoy->diff($fn))->y;
            $in['meses']=($hoy->diff($fn))->m;
            $folio=$in->folios()->where('momento','Caracterización')->first();
            $in['dimSalud']=$folio->dimsalud()->first()?1:0;
            $in['dimEducacion']=$folio->dimeducacion()->first()?1:0;
        }
        $datos['nucleo_codigo']=$nucleo['codigo'];

        $fn=$nucleo->folios()->where('momento','Caracterización')->first();
        $datos['estadoCaracterizacion']=array(
            'dimTyC'        =>$fn->dimtyc()->first()?1:0,
            'dimHabitat'    =>$fn->dimhabitat()->first()?1:0,
            'anexoIngresos' =>$fn->anexoingresos()->first()?1:0
        );
        return response()->json($datos,200);
    }

    // public function documento(){
    //     $users = User::where('id', '>', 4748)->get();

    //     foreach ($users as $key => $user) {
    //         $user['password'] = Hash::make( $user['password'].'fest' );
    //         $user->save();
    //     }
    //     return 'listo';
    // }

    public function proveedores(){
        $proveedores = User::with([
            'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            }
        ])->where('id_role', 6)->where('id', '!=', auth()->user()->id)->paginate(9);

        return response()->json([
            'proveedores' => $proveedores
        ], 200);
    }

    public function proveedoresPublicos(){
        $proveedores = User::with([
            'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            }
        ])->where('id_role', 6)->paginate(9);

        return response()->json([
            'proveedores' => $proveedores
        ], 200);
    }

    public function listadoProveedores(){

        if( auth()->user()->id_role === 2 ){
            $proveedores = User::with([
                'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                }
            ])->where('id_role', 6)->where('id', '!=', auth()->user()->id)->get();
    
            return response()->json([
                'proveedores' => $proveedores
            ], 200);
        }

    }

    public function cambiarPassword( Request $request ){

        if( auth()->user()->id_role === 2 ){
            $data =  $request->all();

            $data['clave'] = Hash::make($data['clave']);
    
            $user = User::find($data['id']);
    
            $user->password = $data['clave'];
    
            $user->save();
    
            return response()->json([
                'message' => 'Contraseña cambiada exitosamente'
            ], 200);
        }

    }

}
