<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\CategoriaUnidadFormRequest;

use App\Unidad;

class UnidadController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth');
    }

    public function index(){
        return Unidad::orderByRaw('id DESC')->get();
    }

    public function store(CategoriaUnidadFormRequest $request){
        if(auth()->user()->id_role == 2){
            $data = $request->all();

            $data['nombre'] = strtoupper($data['nombre']);

            Unidad::create($data);

            return Unidad::all();
        }
    }

    public function update(CategoriaUnidadFormRequest $request){
        if(auth()->user()->id_role == 2){
            $data = $request->all();

            $unidad = Unidad::find($data['id']);
        
            $unidad->nombre = strtoupper($data['unidad_modificada']);

            $unidad->save();

            return Unidad::all();
        }


    }
}
