<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\ProductoFormRequest;
use App\Http\Requests\ActualizarProductoFormRequest;

use App\Producto;
use App\Stock;
use App\ImagenesProducto;

use App\Participante;
use App\Gestor;
use App\User;
use App\Oferta;

class UbicacionController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index', 'show']]);
    }

    public function index(){

        return Producto::with([
            'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'tipoProducto' => function ( $tipo_producto ) {
                $tipo_producto->with('imagenes');
                $tipo_producto->with('categoria');
            },
        ])->get();
    }

    public function ventas(){

        return Oferta::with([
            'producto' => function( $producto ){
                $producto->with(['tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }]);
                $producto->with('usuario');
            },
            'municipioOrigen' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'municipioDestino' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'usuario'
        ])->where('estado', 'ACEPTADO')->get();
    }

    public function recibidos(){

        return Oferta::with([
            'producto' => function( $producto ){
                $producto->with(['tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }]);
                $producto->with('usuario');
            },
            'municipioOrigen' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'municipioDestino' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'usuario'
        ])->where('recibido', 'SI')->get();
    }

    public function show( $id ){

    }

}
