<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\TipoProductoFormRequest;
use App\Http\Requests\ActualizarTipoProductoFormRequest;
use Illuminate\Support\Facades\Storage;

use App\Producto;
use App\Stock;
use App\ImagenesProductoInclusionProductiva;

use App\Participante;
use App\Gestor;

use App\TipoProductoInclusionProductiva;

class TipoProductoInclusionProductivaController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth');
    }

    public function index(){

        if(auth()->user()->id_role == 2){
            return TipoProductoInclusionProductiva::with('imagenes', 'categoria', 'unidad')
                ->orderByRaw('id DESC')
                ->paginate(9);
        }

    }

    public function store(TipoProductoFormRequest $request){

        if(auth()->user()->id_role == 2){
            $data = $request->all();
            
            $producto['id_categoria'] = $data['id_categoria'];
            $producto['id_unidad'] = $data['id_unidad'];
            $producto['nombre'] = strtoupper($data['nombre']);

            $tipoProducto = TipoProductoInclusionProductiva::create($producto);

            foreach ($data['imagenes'] as $key => $imagen) {
                $datos_imagen['img_miniatura']=$imagen->storeAs(
                    'public/Inclusion Productiva/Imagenes', 
                    $tipoProducto['id']. '.' . $imagen->getClientOriginalExtension()
                );

                $datos_imagen['id_tipo_producto'] = $tipoProducto['id'];

                ImagenesProductoInclusionProductiva::create( $datos_imagen );
            }

            return response()->json([
                'susses' => true,
                'message' => 'Registro completado exitosamente',
                'codigo' => 200
            ], 200);
        }


    }

    public function update(ActualizarTipoProductoFormRequest $request){
        $data = $request->all();

        $tipo_producto = TipoProductoInclusionProductiva::find($data['id_tipo_producto']);

        $tipo_producto->nombre = $data['nombre'];
        $tipo_producto->id_categoria = $data['id_categoria'];
        $tipo_producto->id_unidad = $data['id_unidad'];

        $tipo_producto->save();

        if( isset( $data['imagenes'] ) ){
            foreach ($data['imagenes'] as $key => $imagen) {

                $imagen_vieja = ImagenesProductoInclusionProductiva::where('id_tipo_producto', $data['id_tipo_producto'])->first();

                if( $imagen_vieja == null ){

                    $datos_imagen['img_miniatura']=$imagen->storeAs(
                        'public/Inclusion Productiva/Imagenes', 
                        $tipo_producto['id']. '.' . $imagen->getClientOriginalExtension()
                    );
    
                    $datos_imagen['id_tipo_producto'] = $tipo_producto['id'];
    
                    ImagenesProductoInclusionProductiva::create( $datos_imagen );

                }else{
                    Storage::delete($imagen_vieja['img_miniatura']);

                    $datos_imagen['img_miniatura']=$imagen->storeAs(
                        'public/Inclusion Productiva/Imagenes', 
                        $data['id_tipo_producto']. '.' . $imagen->getClientOriginalExtension()
                    );
    
                    $imagen_vieja->img_miniatura = $datos_imagen['img_miniatura'];
                    $imagen_vieja->save();
                }

            }
        }

        return response()->json([
            'susses' => true,
            'message' => 'Actualización completada exitosamente',
            'codigo' => 200
        ], 200);

    }
}
