<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\ProductoFormRequest;

use App\Sesion;

class SesionController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['indexPublico']]);
    }

    public function index(){

        if( auth()->user()->id_role == 2 ){
            return Sesion::with('municipio')->get();
        }else if( auth()->user()->id_role == 7 ){
            return Sesion::where('id_municipio', auth()->user()->id_municipio)->with('municipio')->get();
        }else{
            return Sesion::where('estado', 'DISPONIBLE')->with('municipio')->get();
        }

    }

    public function indexPublico(){

        return Sesion::where('estado', 'DISPONIBLE')->with('municipio')->get();

    }

    public function show( $id ){

    }

    public function store(Request $request){
        
        $datos = $request->all();

        if( substr($datos['link'], 0, 8) == 'https://' ){
            $datos['link'] = $datos['link'];
        }else if( substr($datos['link'], 0, 7) == 'http://' ){
            $datos['link'] = $datos['link'];
        }else{
            $datos['link'] = 'https://'.$datos['link'];
        }

        if( auth()->user()->id_role == 7 ){
            $datos['id_municipio'] = auth()->user()->id_municipio;
        }

        Sesion::create($datos);

        return response()->json([
            'susses'    => true,
            'message'   => 'Registro creado satisfactoriamente.',
            'sesiones'  => Sesion::all(),
            'codigo'    => 200
        ], 200);

    }

    public function update(Request $request){
        $datos = $request->all();

        $sesion = Sesion::where('id', $datos['id'])->first();

        $sesion->nombre = $datos['nombre'];

        if( substr($datos['link'], 0, 8) == 'https://' ){
            $sesion->link   = $datos['link'];
        }else if( substr($datos['link'], 0, 7) == 'http://' ){
            $sesion->link   = $datos['link'];
        }else{
            $sesion->link   = 'https://'.$datos['link'];
        }

        $sesion->estado = $datos['estado'];

        $sesion->save();

        return response()->json([
            'susses' => true,
            'message' => 'Registro actualizado exitosamente',
            'sesiones'  => Sesion::all(),
            'codigo' => 200
        ], 200);
    }

    public function destroy(Request $request){

        $datos = $request->all();

        $sesion = Sesion::where('id', $datos['id'])->first();

        $sesion->delete();

        return response()->json([
            'susses' => true,
            'message' => 'Registro eliminado exitosamente',
            'sesiones'  => Sesion::all(),
            'codigo' => 200
        ], 200);
    }

}
