<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\ProductoFormRequest;
use App\Http\Requests\ActualizarProductoFormRequest;

use App\ProductoProveedor;
use App\StockProveedor;
// use App\ImagenesProducto;

use App\Participante;
use App\Gestor;

class ProductoProveedorController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index', 'show']]);
    }

    public function index(){
        return ProductoProveedor::with([
            'stocks_proveedores', 'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'tipoProductoProveedor' => function ( $tipo_producto ) {
                // $tipo_producto->with('imagenes');
                $tipo_producto->with('categoria_proveedor');
                $tipo_producto->with('unidad');
            }
        ])->where('stock_actual', '>', 0)->paginate(9);
    }

    public function show( $id ){
        $productos = ProductoProveedor::where('id_user', $id)
            ->with([
                'categoria', 'usuario','stocks_proveedores', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                // 'tipoProductoProveedor' => function ( $tipo_producto ) {
                //     // $tipo_producto->with('imagenes');
                //     $tipo_producto->with('categoria_proveedor');
                //     $tipo_producto->with('unidad');
                // }
            ])
            ->paginate(9);

        return $productos;
    }

    public function misProductos(){
        return ProductoProveedor::where('id_user', auth()->user()->id)
            ->with([
                'categoria', 'stocks_proveedores', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                // 'tipoProductoProveedor' => function ( $tipo_producto ) {
                //     // $tipo_producto->with('imagenes');
                //     $tipo_producto->with('categoria_proveedor');
                //     $tipo_producto->with('unidad');
                // }
            ])->paginate(9);
    }

    public function store(ProductoFormRequest $request){

        $gestor = Gestor::where('id_user', auth()->user()->id)->value('id');
        $participante = Participante::where('id_user', auth()->user()->id)->value('id');

        // if(auth()->user()->id_role == 2 || auth()->user()->id_role == 6){

            $datos = $request->all();

            $producto['producto']       = strtoupper( $datos['producto'] );
            $producto['descripcion']    = $datos['descripcion'];
            $producto['id_categoria']   = $datos['id_categoria'];
            $producto['unidad_venta']   = strtoupper( $datos['unidad_venta'] );
            $producto['id_municipio']   = auth()->user()->id_municipio;
            $producto['id_user']        = auth()->user()->id;
            $producto['stock_actual']   = $datos['cantidad'];

            $producto['latitude'] = auth()->user()->latitude;
            $producto['longitude'] = auth()->user()->longitude;

            $producto['zona'] = $producto['id_municipio'] == auth()->user()->id_municipio ? auth()->user()->zona : '';

            // return $producto;

            $nuevoProducto = ProductoProveedor::create( $producto );

            $stock['stock'] = (int) $datos['cantidad'];
            $stock['valor_stock'] = (int) $datos['precio'];
            $stock['descuento'] = (int) $datos['descuento'];
            $stock['id_producto'] = (int) $nuevoProducto['id'];
            StockProveedor::create( $stock );

            // foreach ($datos['imagenes'] as $key => $imagen) {
            //     $datos_imagen['img_miniatura']=$imagen->storeAs(
            //         'public/Mercados Campesinos/imagenes', 
            //         $imagen->getClientOriginalName()
            //     );

            //     $datos_imagen['id_producto'] = $nuevoProducto['id'];

            //     ImagenesProducto::create( $datos_imagen );
            // }

            return response()->json([
                'susses' => true,
                'message' => 'Registro completado exitosamente',
                'codigo' => 200
            ], 200);
        
        // }else{
        //     return response()->json([
        //         'susses' => true,
        //         'message' => 'Usted no se encuentra autorizado para registrar productos.',
        //         'codigo' => 401
        //     ], 401);
        // }
    }

    public function update(ActualizarProductoFormRequest $request){
        $datos = $request->all();
        
        $producto = Producto::find($datos['id']);

        $producto->descripcion = $datos['descripcion'];
        $producto->id_municipio = $datos['id_municipio'];
        $producto->zona = $producto['id_municipio'] == auth()->user()->id_municipio ? auth()->user()->zona : '';

        $stock = Stock::where('id_producto', $datos['id'])->get()->last();

        if( $stock['valor_stock'] == $datos['precio'] && $stock['stock'] == $datos['cantidad'] && $stock['descuento'] == $datos['descuento'] ){
            // El stock no se altera
        }else{
            $nuevoStock['stock'] = $datos['cantidad'];
            $nuevoStock['valor_stock'] = $datos['precio'];
            $nuevoStock['id_producto'] = $datos['id'];
            $nuevoStock['descuento'] = $datos['descuento'];
            Stock::create( $nuevoStock );

            $producto->stock_actual = $datos['cantidad'];
        }

        $producto->save();

        return response()->json([
            'susses' => true,
            'message' => 'Registro actualizado exitosamente',
            'codigo' => 200
        ], 200);
    }

    public function reporte(){
        return 'productos';
    }
}
