<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\ProductoFormRequest;
use App\Http\Requests\ActualizarProductoFormRequest;

use App\Producto;
use App\Stock;
use App\ImagenesProducto;

use App\Participante;
use App\Gestor;

class ProductoController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index', 'show']]);
    }

    public function index(){
        return Producto::with([
            'stocks', 'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'tipoProducto' => function ( $tipo_producto ) {
                $tipo_producto->with('imagenes');
                $tipo_producto->with('categoria');
                $tipo_producto->with('unidad');
            }
        ])->where('stock_actual', '>', 0)->paginate(9);
    }

    public function show( $id ){
        $producto = Producto::where('id', $id)
            ->with([
                'stocks', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                'tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }
            ])
            ->first();

        return $producto;
    }

    public function misProductos(){
        return Producto::where('id_user', auth()->user()->id)
            ->with([
                'stocks', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                'tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }
            ])->paginate(9);
    }

    public function store(ProductoFormRequest $request){

        $gestor = Gestor::where('id_user', auth()->user()->id)->value('id');
        $participante = Participante::where('id_user', auth()->user()->id)->value('id');

        if($gestor != '' || $participante != '' || auth()->user()->id_role == 2){

            $datos = $request->all();
            $producto['id_tipo_producto'] = $datos['id_producto'];
            $producto['descripcion'] = $datos['descripcion'];
            // $producto['id_municipio'] = $datos['id_municipio'];
            $producto['id_municipio'] = auth()->user()->id_municipio;
            $producto['id_user'] = auth()->user()->id;
            $producto['stock_actual'] = $datos['cantidad'];

            $producto['latitude'] = auth()->user()->latitude;
            $producto['longitude'] = auth()->user()->longitude;

            $producto['zona'] = $producto['id_municipio'] == auth()->user()->id_municipio ? auth()->user()->zona : '';

            // return $producto;

            $nuevoProducto = Producto::create( $producto );

            $stock['stock'] = $datos['cantidad'];
            $stock['valor_stock'] = $datos['precio'];
            $stock['descuento'] = $datos['descuento'];
            $stock['id_producto'] = $nuevoProducto['id'];
            Stock::create( $stock );

            // foreach ($datos['imagenes'] as $key => $imagen) {
            //     $datos_imagen['img_miniatura']=$imagen->storeAs(
            //         'public/Mercados Campesinos/imagenes', 
            //         $imagen->getClientOriginalName()
            //     );

            //     $datos_imagen['id_producto'] = $nuevoProducto['id'];

            //     ImagenesProducto::create( $datos_imagen );
            // }

            return response()->json([
                'susses' => true,
                'message' => 'Registro completado exitosamente',
                'codigo' => 200
            ], 200);
        
        }else{
            return response()->json([
                'susses' => true,
                'message' => 'Usted no se encuentra autorizado para registrar productos.',
                'codigo' => 401
            ], 401);
        }
    }

    public function update(ActualizarProductoFormRequest $request){
        $datos = $request->all();
        
        $producto = Producto::find($datos['id']);

        $producto->descripcion = $datos['descripcion'];
        $producto->id_municipio = $datos['id_municipio'];
        $producto->zona = $producto['id_municipio'] == auth()->user()->id_municipio ? auth()->user()->zona : '';

        $stock = Stock::where('id_producto', $datos['id'])->get()->last();

        if( $stock['valor_stock'] == $datos['precio'] && $stock['stock'] == $datos['cantidad'] && $stock['descuento'] == $datos['descuento'] ){
            // El stock no se altera
        }else{
            $nuevoStock['stock'] = $datos['cantidad'];
            $nuevoStock['valor_stock'] = $datos['precio'];
            $nuevoStock['id_producto'] = $datos['id'];
            $nuevoStock['descuento'] = $datos['descuento'];
            Stock::create( $nuevoStock );

            $producto->stock_actual = $datos['cantidad'];
        }

        $producto->save();

        return response()->json([
            'susses' => true,
            'message' => 'Registro actualizado exitosamente',
            'codigo' => 200
        ], 200);
    }

    public function reporte(){
        return 'productos';
    }
}
