<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\ProductoProveedor;
use App\Producto;
use App\ProductoInclusionProductiva;
use App\User;

class FiltroController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['filtroPublico', 'filtroPublicoInclusionProductiva', 'filtroProveedores', 'filtroProductosProveedores']]);
    }

    public function filtroPublico(Request $request){
        $datos = $request->all();

        /**
         * Filtra solo por productos
         */
        if( count($datos['municipios']) == 0 && count($datos['productos']) > 0 ){
            
            $productos = Producto::WhereIn('id_tipo_producto', $datos['productos'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                    ->paginate(9);
        }
        /**
         * Filtra solo por municipios
         */
        else if(count($datos['municipios']) > 0 && count($datos['productos']) == 0){
            $productos = Producto::whereIn('id_municipio', $datos['municipios'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                    ->paginate(9);
        }
        /**
         * Filtra por municipios y los productos de esos municipio
         */
        else if(count($datos['municipios']) > 0 && count($datos['productos']) > 0){
            $productos = Producto::whereIn('id_tipo_producto', $datos['productos'])
                ->whereIn('id_municipio', $datos['municipios'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                ->paginate(9);

                return $productos;
        }else{
            // $productos = Producto::whereIn('id_municipio', $datos['municipios'])
            // ->orWhereIn('id_tipo_producto', $datos['productos'])
            // ->with([
            //     'stocks', 'municipio' => function ( $municipio ) {
            //         $municipio->with('departamento');
            //     },
            //     'tipoProducto' => function ( $tipo_producto ) {
            //         $tipo_producto->with('imagenes');
            //         $tipo_producto->with('categoria');
            //         $tipo_producto->with('unidad');
            //     }
            // ])->where('stock_actual', '>', 0)
            //     ->paginate(9);
        }

        return $productos;
    }

    public function filtroPublicoInclusionProductiva(Request $request){
        $datos = $request->all();

        /**
         * Filtra solo por productos
         */
        if( count($datos['municipios']) == 0 && count($datos['productos']) > 0 ){
            
            $productos = ProductoInclusionProductiva::WhereIn('id_tipo_producto', $datos['productos'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                    ->paginate(9);
        }
        /**
         * Filtra solo por municipios
         */
        else if(count($datos['municipios']) > 0 && count($datos['productos']) == 0){
            $productos = ProductoInclusionProductiva::whereIn('id_municipio', $datos['municipios'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                    ->paginate(9);
        }
        /**
         * Filtra por municipios y los productos de esos municipio
         */
        else if(count($datos['municipios']) > 0 && count($datos['productos']) > 0){
            $productos = ProductoInclusionProductiva::whereIn('id_tipo_producto', $datos['productos'])
                ->whereIn('id_municipio', $datos['municipios'])
                ->with([
                    'stocks', 'municipio' => function ( $municipio ) {
                        $municipio->with('departamento');
                    },
                    'tipoProducto' => function ( $tipo_producto ) {
                        $tipo_producto->with('imagenes');
                        $tipo_producto->with('categoria');
                        $tipo_producto->with('unidad');
                    }
                ])->where('stock_actual', '>', 0)
                ->paginate(9);

                return $productos;
        }else{
            // $productos = Producto::whereIn('id_municipio', $datos['municipios'])
            // ->orWhereIn('id_tipo_producto', $datos['productos'])
            // ->with([
            //     'stocks', 'municipio' => function ( $municipio ) {
            //         $municipio->with('departamento');
            //     },
            //     'tipoProducto' => function ( $tipo_producto ) {
            //         $tipo_producto->with('imagenes');
            //         $tipo_producto->with('categoria');
            //         $tipo_producto->with('unidad');
            //     }
            // ])->where('stock_actual', '>', 0)
            //     ->paginate(9);
        }

        return $productos;
    }

    public function filtroPrivado(Request $request){
        $datos = $request->all();
        
        $productos = Producto::where('id_user', auth()->user()->id)
            ->whereIn('id_municipio', $datos['municipios'])
            ->WhereIn('id_tipo_producto', $datos['productos'])
            ->with([
                'stocks', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                //  => function ( $stock ) {
                //     $stock->orderBy('created_at', 'desc')->first();
                //     // $stock->whereBetween('valor_stock', [1, 100]);
                // },
                'tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }
            ])
            ->paginate(9);

        return $productos;
    }

    public function filtroPrivadoInclusionProductiva(Request $request){
        $datos = $request->all();
        
        $productos = ProductoInclusionProductiva::where('id_user', auth()->user()->id)
            ->whereIn('id_municipio', $datos['municipios'])
            ->WhereIn('id_tipo_producto', $datos['productos'])
            ->with([
                'stocks', 'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                },
                //  => function ( $stock ) {
                //     $stock->orderBy('created_at', 'desc')->first();
                //     // $stock->whereBetween('valor_stock', [1, 100]);
                // },
                'tipoProducto' => function ( $tipo_producto ) {
                    $tipo_producto->with('imagenes');
                    $tipo_producto->with('categoria');
                    $tipo_producto->with('unidad');
                }
            ])
            ->paginate(9);

        return $productos;
    }

    public function filtroProveedoresPublicos(Request $request){

        $datos = $request->all();

        $proveedores = User::whereIn('id_municipio', $datos['municipios'])->with([
            'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            }
        ])->where('id_role', 6)->paginate(9);

        return response()->json([
            'proveedores' => $proveedores
        ], 200);
    }

    public function filtroProveedoresPrivados(Request $request){

        $datos = $request->all();

        // if( $datos['proveedor'] != '' ){

        //     $p = $datos['proveedor'];
        //     $proveedores = User::whereIn('id_municipio', $datos['municipios'])->with([
        //         'municipio' => function ( $municipio ) {
        //             $municipio->with('departamento');
        //         }
        //     ])
        //         ->where('nombre_almacen', $p)->paginate(9);

        // }else{

            $proveedores = User::whereIn('id_municipio', $datos['municipios'])->with([
                'municipio' => function ( $municipio ) {
                    $municipio->with('departamento');
                }
            ])->where('id_role', 6)->where('id', '!=', auth()->user()->id)->paginate(9);

        // }

        return response()->json([
            'proveedores' => $proveedores
        ], 200);
    }

    public function filtroProductosProveedores(Request $request){

        $datos = $request->all();

        return ProductoProveedor::whereIn('id', $datos['productos'])->with([
            'usuario', 'categoria', 'stocks_proveedores', 'municipio' => function ( $municipio ) {
                $municipio->with('departamento');
            },
            'tipoProductoProveedor' => function ( $tipo_producto ) {
                // $tipo_producto->with('imagenes');
                $tipo_producto->with('categoria_proveedor');
                $tipo_producto->with('unidad');
            }
        ])->where('stock_actual', '>', 0)->paginate(9);


    }
}
