<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Departamento;

class DepartamentoController extends Controller
{
    
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index']]);
    }

    public function index( $tipo_mercado ){

        if( $tipo_mercado === 'producto' ){
            return Departamento::with([
                'municipios' => function( $municipio ) {
                    $municipio->withCount('productos');
                }])->get();
        }else if( $tipo_mercado === 'proveedor' ){
            return Departamento::with([
                'municipios' => function( $municipio ) {
                    $municipio->withCount('proveedores');
                }])->get();
        }if( $tipo_mercado === 'inclusion' ){
            return Departamento::with([
                'municipios' => function( $municipio ) {
                    $municipio->withCount('productosInclusion');
                }])->get();
        }
    }


}
