<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\CategoriaUnidadFormRequest;

use App\CategoriaProveedor;
use App\ProductoProveedor;
use App\TipoProductoProveedor;

class CategoriaProveedorController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index']]);
    }

    public function index(){
        return CategoriaProveedor::with([
            'tipos_productos_proveedores' => function ( $tipo_producto ) {
                $tipo_producto->with('unidad');
                // $tipo_producto->withCount('productos_proveedor');
            }
        ])->orderByRaw('id DESC')->get();
    }

    public function privateIndex( Request $request ){

        $data = $request->all();
        
        if (!isset($data['id_proveedor'])) {
            $data['id_proveedor'] = auth()->user()->id;
        }

        $productos = ProductoProveedor::where('id_user', $data['id_proveedor'])->get();
        $categorias = array();
        foreach ($productos as $key => $producto) {
            // $tipo_producto = TipoProductoProveedor::find($producto['id_tipo_producto']);
            $categoria = CategoriaProveedor::where('id', $producto['id_categoria'])->first();
            $categorias[] = $categoria;
            // array_push($categorias, $categoria);
        }

        $categoriasF = array_unique( $categorias );

        foreach ($categoriasF as $key => $categoria) {
            
            $categoria['productos'] = ProductoProveedor::where('id_user', $data['id_proveedor'])->where('id_categoria', $categoria['id'])->get();
            
        }

        return $categoriasF;


        // $categoriasFiltradas = array();
        // foreach ($categoriasF as $key => $categoria) {
        //     $categoriasFiltradas[] = $categoria;
        // }

        // foreach ($categoriasFiltradas as $key => $categoria) {
        //     $tiposProductos = array();
        //     foreach ($productos as $key => $producto) {
        //         $tipo_producto = TipoProductoProveedor::find($producto['id_tipo_producto']);
        //         if($tipo_producto['id_categoria'] == $categoria['id']){
        //             $tiposProductos[] = $tipo_producto;
        //             // array_push($tiposProductos, $tipo_producto);
        //         }
        //     }

        //     $categoria['tipos_productos_proveedores'] = $tiposProductos;
        // }

        // return $categoriasFiltradas;


    //     return CategoriaProveedor::with([
    //         'tipos_productos_proveedores' => function ( $tipo_producto ) {
    //             $tipo_producto->with('unidad');
    //             // $tipo_producto->withCount('productos_proveedores');
    //         }
    //     ])->orderByRaw('id DESC')->get();
    }

    public function listadoAdministrador(){
        return CategoriaProveedor::with([
            'tipos_productos_proveedores' => function ( $tipo_producto ) {
                $tipo_producto->with('unidad');
                // $tipo_producto->withCount('productos_proveedores');
            }
        ])->orderByRaw('id DESC')->get();
    }

    public function store(CategoriaUnidadFormRequest $request){
        $data = $request->all();

        $data['nombre'] = strtoupper($data['nombre']);

        $categoria = CategoriaProveedor::create($data);

        return CategoriaProveedor::all();
    }

    public function update(CategoriaUnidadFormRequest $request){
        $data = $request->all();

        $categoria = CategoriaProveedor::find($data['id']);
    
        $categoria->nombre = strtoupper($data['categoria_modificada']);

        $categoria->save();

        return CategoriaProveedor::all();

    }
    
}
