<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\CategoriaUnidadFormRequest;

use App\Categoria;

class CategoriaController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth', ['except' => ['index']]);
    }

    public function index(){
        return Categoria::with([
            'tipos_productos' => function ( $tipo_producto ) {
                $tipo_producto->with('unidad');
                // $tipo_producto->withCount('productos');
            }
        ])->get();
    }

    public function privateIndex(){
        return Categoria::orderByRaw('id DESC')->get();
    }

    public function store(CategoriaUnidadFormRequest $request){
        $data = $request->all();

        $data['nombre'] = strtoupper($data['nombre']);

        $categoria = Categoria::create($data);

        return Categoria::all();
    }

    public function update(CategoriaUnidadFormRequest $request){
        $data = $request->all();

        $categoria = Categoria::find($data['id']);
    
        $categoria->nombre = strtoupper($data['categoria_modificada']);

        $categoria->save();

        return Categoria::all();

    }
    
}
