<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Oferta;
use App\ProductoProveedor;
use App\Municipio;
use App\Stock;
use App\Participante;
use App\Carrito;
use App\CarritoProducto;
use App\CarritoProveedor;

class CarritoProductoController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth');
    }

    /**
     * Retorna todos los productos que tienen ofertas pendientes y del usuario autenticado.
     */
    public function index(){

        return Carrito::where('id_user', auth()->user()->id)
                    ->with(['proveedor' => function ( $proveedor ){
                        $proveedor->with('municipio');
                    }, 'carritoProductos' => function ( $carritoProducto ){
                        $carritoProducto->with(['productoProveedor' => function ( $producto ){
                            $producto->with(['tipoProductoProveedor' => function ( $tipoProducto ){
                                $tipoProducto->with('unidad');
                            }]);
                            $producto->with('stocks_proveedores');
                        }]);
                    }])->get();
        
        // with(['tipoProducto' => function ( $tipo ){
        //         $tipo->with('imagenes');
        //     }])->withCount([
        //         'ofertas as ofertas_pendientes' => function ( $oferta ) {
        //             $oferta->where('estado', 'EN PROCESO');
        //         }
        //     ])->having('ofertas_pendientes', '>', 0)
        //         ->having('id_user', auth()->user()->id)->get();

    }

    public function totalOfertas(){

        $productos = Producto::withCount([
            'ofertas as ofertas_pendientes' => function ( $oferta ) {
                $oferta->where('estado', 'EN PROCESO');
            }
        ])->having('ofertas_pendientes', '>', 0)
            ->having('id_user', auth()->user()->id)->get();

        return count( $productos );
    }

    /**
     * Muestra todas las ofetas de un unico producto
     */

    public function show( Request $request ) {
        $data = $request->all();
        $producto = Producto::with([
            'stocks',
            'tipoProducto' => function ( $tipo ){
                $tipo->with('imagenes');
                $tipo->with('unidad');
            },
            'ofertas' => function ( $oferta ) {
                $oferta->with(['usuario' => function ( $user ){
                    $user->with('participante');
                }]);
                $oferta->with('municipioOrigen');
                $oferta->with('municipioDestino');
                $oferta->where('estado', 'EN PROCESO');
            }
        ])->having('id', $data['id_producto'])->first();

        $producto['oferta_inicial'] = $producto['ofertas'];
        
        if($producto['oferta_inicial'] != null){
            return $producto;
        }else{
            return response()->json([
                'susses' => false,
                'message' => 'Producto no encontrado',
                'codigo' => 404
            ], 404);
        }
    }

    public function store(Request $request){

        $datos = $request->all();

        if( auth()->user()->id_role == 7){

            return response()->json([
                'susses' => false,
                'message' => 'No es posible ofertar sobre tu producto.',
                'codigo' => 403
            ], 403);

        }

        $carritoActivo = Carrito::where('id_proveedor', $datos['id_proveedor'])->where('id_user', auth()->user()->id)->where('estado', 'NO ENVIADO')->first();

        if( $carritoActivo == null ){
            $carrito['id_proveedor'] = $datos['id_proveedor'];
            $carrito['id_user'] = auth()->user()->id;
            $carrito['estado'] = 'NO ENVIADO';
    
            $carritoActivo = Carrito::create( $carrito );
        }

        $carritoProducto['id_carrito'] = $carritoActivo['id'];
        $carritoProducto['id_producto'] = $datos['id'];
        $carritoProducto['cantidad'] = $datos['cantidad'];

        CarritoProducto::create( $carritoProducto );

        // if( $producto['id_user'] === auth()->user()->id ){

        //     return response()->json([
        //         'susses' => false,
        //         'message' => 'No es posible ofertar sobre tu producto.',
        //         'codigo' => 403
        //     ], 403);

        // }

        // $datosOferta['direccion_destino'] = auth()->user()->direccion;
        // $datosOferta['id_municipio_destino'] = auth()->user()->id_municipio;
        // $datosOferta['id_user'] = auth()->user()->id;

        // $stocks = Stock::where('id_producto', $datosOferta['id_producto'])->get();

        // $datosOferta['id_stock'] = $stocks[count($stocks)-1]['id'];

        // $nuevaOferta = Oferta::create( $datosOferta );

        return response()->json([
            'susses' => true,
            'message' => 'Producto Agregado Exitosamente',
            'codigo' => 200
        ], 200);
    }

    public function informacionOferta( $id ){
        $oferta = Oferta::where('id', $id)
            ->with([
                'producto' => function ( $producto ) {
                    $producto->with('tipoProducto');
                },
                'usuario',
                'municipioOrigen',
                'municipioDestino',

            ])
            ->first();
        
        if($oferta['usuario']['id'] === auth()->user()->id || auth()->user()->id_role === 2){
            $oferta['vendedor'] = User::where('id', $oferta['producto']['id_user'])->first();
            $oferta['stock_oferta'] = Stock::where('id', $oferta['id_stock'])->first();
            $oferta['es_participante'] = Participante::where('id_user', $oferta['id_user'])->first() == null ? 'NO' : 'SI';
            return $oferta;
        }

        return response()->json([
            'susses' => false,
            'message' => 'Solicitud no permitida.',
            'codigo' => 403
        ], 403);


    }

    public function update( Request $request ) {
        $data = $request->all();
        $producto = CarritoProducto::find( $data['id'] );
        $producto->cantidad = $data['cantidad'];
        $producto->save();

        return response()->json([
            'susses' => true,
            'message' => 'Actualización completada exitosamente',
            'codigo' => 200
        ], 200);


    }

    public function delete( Request $request ) {
        $data = $request->all();
        $producto = CarritoProducto::find( $data['id'] );

        $id_carrito_proveedor = $producto['id_carrito_proveedor'];

        $producto->delete();

        $productos = CarritoProducto::where('id_carrito_proveedor', $id_carrito_proveedor)->get();

        if( count( $productos ) == 0 ){
            $carritoProveedor = CarritoProveedor::find($id_carrito_proveedor);
            $id_carrito = $carritoProveedor['id_carrito'];
            
            $carritoProveedor->delete();

            $proveedores = CarritoProveedor::where('id_carrito', $id_carrito)->get();

            if( count( $proveedores ) == 0 ){
                $carrito = Carrito::find($id_carrito);
                $carrito->delete();
            }
        }

        return response()->json([
            'susses' => true,
            'message' => 'Producto Eliminado Correctamente.',
            'codigo' => 200
        ], 200);


    }

    public function ofertasRealizadas(){
        return Oferta::with(['producto' => function ( $producto ){
                    $producto->with(['tipoProducto' => function ( $tipo ){
                        $tipo->with('imagenes');
                    }]);
                }])
                ->where('id_user', auth()->user()->id)->get();
    }

    public function respuestas(){
        return count(Oferta::where('id_user', auth()->user()->id)
                ->whereIn('estado', ['RECHAZADO', 'ACEPTADO'])
                ->where('visto', 'NO')->get());
    }

    public function visado(Request $request){
        $data = $request->all();

        $oferta = Oferta::find($data['id']);

        $oferta->visto="SI";

        $oferta->save();

        return count(Oferta::where('id_user', auth()->user()->id)
                ->whereIn('estado', ['RECHAZADO', 'ACEPTADO'])
                ->where('visto', 'NO')->get());
    }

    public function compraRecibida(Request $request){
        $data = $request->all();

        $oferta = Oferta::find($data['oferta']);

        if($oferta['estado'] !== 'RECHAZADO'){
            $oferta->latitude = $data['latitude'];
            $oferta->longitude = $data['longitude'];
            $oferta->recibido = 'SI';

            $oferta->save();

            $oferta->fecha_recibido = $oferta['updated_at'];

            $oferta->save();
        }

        return Oferta::with(['producto' => function ( $producto ){
            $producto->with(['tipoProducto' => function ( $tipo ){
                $tipo->with('imagenes');
            }]);
        }])
        ->where('id_user', auth()->user()->id)->get();
    }

}
