<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Oferta;
use App\ProductoProveedor;
use App\Municipio;
use App\Stock;
use App\Participante;
use App\Carrito;
use App\CarritoProveedor;
use App\CarritoProducto;

class CarritoController extends Controller
{
    public function __construct(){
        $this->middleware('jwt.auth');
    }

    /**
     * Retorna todos los productos que tienen ofertas pendientes y del usuario autenticado.
     */
    public function index(){

        return Carrito::where('id_user', auth()->user()->id)->where('estado', 'NO ENVIADO')
                ->with(['carritoProveedores' => function( $carritoProveedor ){
                    $carritoProveedor->with(['proveedor' => function( $proveedor ){
                        $proveedor->with('municipio');
                    }, 'carritoProductos' => function ( $carritoProducto ){
                        $carritoProducto->with(['productoProveedor' => function ( $producto ){
                            // $producto->with(['tipoProductoProveedor' => function ( $tipoProducto ){
                            //     $tipoProducto->with('unidad');
                            // }]);
                            $producto->with('stocks_proveedores');
                            $producto->with('categoria');
                        }]);
                    }]);
                }])->first();

    }

    public function carritosEnviados(){
        return Carrito::where('id_user', auth()->user()->id)->where('estado', 'ENVIADO')
            ->with(['carritoProveedores' => function( $carritoProveedor ){
                $carritoProveedor->with(['proveedor' => function( $proveedor ){
                    $proveedor->with('municipio');
                }]);
            }])->get();
    }


    /**
     * Muestra todas las ofetas de un unico producto
     */

    public function show( $id ) {
        return Carrito::where('id', $id)->where('id_user', auth()->user()->id)
                ->with(['carritoProveedores' => function( $carritoProveedor ){
                    $carritoProveedor->with(['proveedor' => function( $proveedor ){
                        $proveedor->with('municipio');
                    }, 'carritoProductos' => function ( $carritoProducto ){
                        $carritoProducto->with(['productoProveedor' => function ( $producto ){
                            $producto->with(['tipoProductoProveedor' => function ( $tipoProducto ){
                                $tipoProducto->with('unidad');
                            }]);
                            $producto->with('stocks_proveedores');
                        }, 'oferta']);
                    }]);
                }])->first();
    }

    public function store(Request $request){

        $datos = $request->all();

        if( auth()->user()->id_role == 7){

            return response()->json([
                'susses' => false,
                'message' => 'No es posible ofertar sobre tu producto.',
                'codigo' => 403
            ], 403);

        }

        $carritoActivo = Carrito::where('id_user', auth()->user()->id)->where('estado', 'NO ENVIADO')->first();

        if( $carritoActivo == null ){
            $carrito['id_user'] = auth()->user()->id;
            $carrito['estado'] = 'NO ENVIADO';
    
            $carritoActivo = Carrito::create( $carrito );
        }

        $carritoProveedor = CarritoProveedor::where('id_carrito', $carritoActivo['id'])->where('id_proveedor', $datos['id_proveedor'])->first();

        if( $carritoProveedor == null ){
            $carritoProveedor = CarritoProveedor::create( [ 'id_carrito' => $carritoActivo['id'], 'id_proveedor' => $datos['id_proveedor'] ] );
        }

        $carritoProducto = CarritoProducto::where('id_carrito_proveedor', $carritoProveedor['id'])->where('id_producto', $datos['id'])->first();

        if( $carritoProducto == null ){
            $carritoProducto['id_carrito_proveedor'] = $carritoProveedor['id'];
            $carritoProducto['id_producto'] = $datos['id'];
            $carritoProducto['cantidad'] = $datos['cantidad'];
    
            CarritoProducto::create( $carritoProducto );
        }else{
            $carritoProducto->cantidad = $carritoProducto->cantidad + $datos['cantidad'];
            $carritoProducto->save();
        }



        $conteo = Carrito::where('id', $carritoActivo['id'])
                    ->with(['carritoProveedores' => function( $carritoProveedor ){
                        $carritoProveedor->withCount('carritoProductos');
                    }])
                    ->first();


        return response()->json([
            'susses' => true,
            'message' => 'Producto Agregado Exitosamente',
            'dato' => $conteo,
            'codigo' => 200
        ], 200);
    }

    public function notificaciones( Request $request ) {
        return Carrito::where('id_user', auth()->user()->id)->where('estado', 'NO ENVIADO')
                    ->with(['carritoProveedores' => function( $carritoProveedor ){
                        $carritoProveedor->withCount('carritoProductos');
                    }])
                    ->first();
    }

    public function update( Request $request ) {


    }


}
