<?php

namespace App\Http\Controllers;

use JWTAuth;
use App\User;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;
use Tymon\JWTAuthExceptions\JWTException;

use Illuminate\Support\Facades\Hash;

use App\Http\Requests\RegistrarUsuarioFormRequest;
use App\Http\Requests\LoginFormRequest;

use App\MenuTipo;

class AuthenticateController extends Controller
{
    public function __construct(){
       $this->middleware('jwt.auth', ['except' => ['login', 'registrar']]);
   }

    /**
     * Registra un nuevo usuario en el sistema.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function registrar(RegistrarUsuarioFormRequest $request) {

        $datos = $request->all();

        $datos['password'] = Hash::make( $datos['password'] );
        // $datos['id_role'] = 4;

        $user = User::create( $datos );

        return response()->json([
            'susses' => true,
            'message' => 'Registro completado exitosamente',
            'codigo' => 200
        ], 200);
    }

    /**
     * Consede accesos al sistema creando un token de autorización.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function login(LoginFormRequest $request){

        $credenciales = $request->only('cedula', 'password');
        $user = User::where('cedula', $credenciales['cedula'])->value('id');

        $rutas = [];

        try {

            if (! $token = JWTAuth::attempt($credenciales)) {
                return response()->json([
                    'success' => false,
                    'message' => 'Credenciales invalidas.',
                    'status' => 401
                ], 401);
            }else{

                if(auth()->user()->id_role == 5){
                    $rutas = MenuTipo::with('opciones')->where('titulo', 'UBICACIONES')->get();
                }else if(auth()->user()->id_role == 2){
                    $rutas = MenuTipo::with('opciones')->get();
                }

                return response()->json([
                        'success' => true,
                        'message' => 'Inicio de sesión exitoso.',
                        'access_type' => 'Bearer',
                        'token' => $token,
                        'key' => $user,
                        'rutas' => $rutas
                    ], 200
                );
            }

        } catch (JWTException $e) {

            return response()->json([
                'success' => false,
                'message' => 'No se pudo iniciar sesión, intentelo más tarde.',
                'status' => 500
            ], 500);

        }
    }

    /**
     * Elimina el token de autorización cerrando la sesion del usuario.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request) {

        auth()->logout();

        return response()->json([
            'susses' => true,
            'message' => 'logout',
            'codigo' => 200
        ], 200);
    }
}
