<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class ReporteExport implements FromArray, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
	public function __construct($dim)
    {
        $this->dim=$dim;

        if($this->dim=='productos'){

            $this->headings = [
                'DOCUMENTO', 
                'PARTICIPANTE', 
                'TELEFONO', 
                'MUNICIPIO', 
                'PRODUCTO', 
                'CANTIDAD', 
                'UNIDAD', 
                'DESCRIPCIÓN', 
                'VALOR' 
            ];

        }

        if($this->dim=='ventas' || $this->dim=='ventasInclusion'){

            $this->headings = [
                'ID',
                'DOCUMENTO OFERTANTE', 
                'OFERTANTE', 
                'TELEFONO OFERTANTE', 
                'PRODUCTO',
                'DESCRIPCIÓN', 
                'UNIDAD DE MEDIDA', 
                'CANTIDAD OFERTA', 
                'VALOR UNITARIO OFERTA', 
                'VALOR TOTAL OFERTA', 
                'ESTADO',
                'CANTIDAD VENTA',
                'VALOR UNITARIO VENTA', 
                'VALOR TOTAL VENTA', 
                'DESCUENTO', 
                'VALOR TOTAL VENTA CON DESCUENTO' ,
                'DEPARTAMENTO DE ORIGEN', 
                'MUNICIPIO DE ORIGEN', 
                'DEPARTAMENTO DE DESTINO', 
                'MUNICIPIO DE DESTINO',
                'DIRECCIÓN DE DESTINO', 
                'METODO DE PAGO', 
                'METODO DE ENVIO', 
                'VALOR DEL ENVIO', 
                'DOCUMENTO VENDEDOR',  
                'VENDEDOR', 
                'TELEFONO VENDEDOR', 
                'CLIENTE FEST', 
                'FECHA DE LA OFERTA'
            ];

        }

        if($this->dim=='ventasProveedores'){

            $this->headings = [
                'ID',
                'DOCUMENTO OFERTANTE', 
                'OFERTANTE', 
                'TELEFONO OFERTANTE', 
                'ORGANIZACIÓN',
                'PRODUCTO',
                'CATEGORIA',
                'DESCRIPCIÓN', 
                'UNIDAD DE VENTA', 
                'CANTIDAD OFERTA', 
                'VALOR UNITARIO OFERTA', 
                'VALOR TOTAL OFERTA', 
                'ESTADO',
                'CANTIDAD VENTA',
                'VALOR UNITARIO VENTA', 
                'VALOR TOTAL VENTA', 
                'DESCUENTO', 
                'VALOR TOTAL VENTA CON DESCUENTO' ,
                'DEPARTAMENTO DE ORIGEN', 
                'MUNICIPIO DE ORIGEN', 
                'DEPARTAMENTO DE DESTINO', 
                'MUNICIPIO DE DESTINO',
                'DIRECCIÓN DE DESTINO', 
                'METODO DE PAGO', 
                'METODO DE ENVIO', 
                'VALOR DEL ENVIO', 
                'DOCUMENTO VENDEDOR',  
                'NOMBRE DEL VENDEDOR',
                'NOMBRE DEL NEGOCIO', 
                'TELEFONO VENDEDOR',
                'FECHA DE LA OFERTA'
            ];

        }

        if($this->dim=='proveedores'){
            $this->headings = [
            'DOCUMENTO VENDEDOR', 
            'NOMBRE DEL VENDEDOR', 
            'NOMBRE DEL NEGOCIO', 
            'TELEFONO VENDEDOR' , 
            'email', 
            'direccion',
            'NIT', 
            'RUT', 
            'DESCRIPCIÓN DEL ALMACEN',
            'PRODUCTO',
            'DESCRIPCIÓN',
            'CATEGORIA',
            'UNIDAD DE VENTA'
            ];


        }

    }

    public function array():array{

        if($this->dim=='proveedores'){
            $reporte=DB::select("SELECT cedula AS 'DOCUMENTO VENDEDOR', 
            CONCAT_WS(' ',primer_nombre, segundo_nombre, primer_apellido, segundo_apellido) AS 'NOMBRE DEL VENDEDOR', 
            nombre_almacen AS 'NOMBRE DEL NEGOCIO', 
            telefono 'TELEFONO VENDEDOR' , 
            email AS 'email', 
            direccion AS 'direccion',
            nit AS 'NIT', 
            rut AS 'RUT', 
            descripcion_almacen AS 'DESCRIPCIÓN DEL ALMACEN',
            producto AS 'PRODUCTO',
            descripcion AS 'DESCRIPCIÓN',
            categorias_proveedores.nombre AS 'CATEGORIA',
            unidad_venta AS 'UNIDAD DE VENTA'
            FROM productos_proveedores inner join categorias_proveedores on productos_proveedores.id_categoria=categorias_proveedores.id inner join users on users.id=productos_proveedores.id_user WHERE users.id_role=6");


        }
        if($this->dim=='productos'){
            $reporte=DB::select("SELECT users.cedula, CONCAT_WS(' ',users.primer_nombre, users.segundo_nombre, users.primer_apellido, users.segundo_apellido) AS 'PARTICIPANTE', users.telefono AS 'TELEFONO', municipios.nombre AS 'MUNICIPIO', tipo_productos.nombre AS 'PRODUCTO', ( SELECT stock FROM stocks WHERE id_producto=productos.id ORDER BY created_at ASC LIMIT 1 ) AS 'CANTIDAD', unidades.nombre 'UNIDAD', productos.descripcion AS 'DESCRIPCIÓN', ( SELECT valor_stock FROM stocks WHERE id_producto=productos.id ORDER BY created_at ASC LIMIT 1 ) AS 'VALOR' FROM productos INNER JOIN users ON users.id=productos.id_user INNER JOIN tipo_productos ON tipo_productos.id=productos.id_tipo_producto INNER JOIN unidades ON unidades.id=tipo_productos.id_unidad INNER JOIN municipios ON municipios.id=users.id_municipio");
        }

        if($this->dim=='ventas'){
            $reporte=DB::select("SELECT ofertas.id, users.cedula AS 'DOCUMENTO OFERTANTE', CONCAT_WS(' ',users.primer_nombre, users.segundo_nombre, users.primer_apellido, users.segundo_apellido) AS 'OFERTANTE', users.telefono AS 'TELEFONO OFERTANTE', tipo_productos.nombre AS PRODUCTO, productos.descripcion AS 'DESCRIPCIÓN', unidades.nombre AS 'UNIDAD DE MEDIDA', ofertas.cantidad AS 'CANTIDAD OFERTA', ofertas.valor_unitario AS 'VALOR UNITARIO OFERTA', ( ofertas.valor_unitario * ofertas.cantidad ) AS 'VALOR TOTAL OFERTA', ofertas.estado AS ESTADO, ofertas.cantidad_venta AS 'CANTIDAD VENTA',ofertas.valor_unitario_venta AS 'VALOR UNITARIO VENTA', ( ofertas.valor_unitario_venta * ofertas.cantidad_venta ) AS 'VALOR TOTAL VENTA', stocks.descuento AS DESCUENTO, ROUND( (ofertas.valor_unitario_venta * ofertas.cantidad_venta) - (ofertas.valor_unitario_venta * ofertas.cantidad_venta) * ( stocks.descuento / 100 ) ) AS 'VALOR TOTAL VENTA CON DESCUENTO' ,( SELECT d1.nombre FROM departamentos as d1 WHERE id=( SELECT m1.id_departamento FROM municipios as m1 WHERE id=ofertas.id_municipio_origen ) ) as 'DEPARTAMENTO DE ORIGEN', ( SELECT m1.nombre FROM municipios as m1 WHERE id=ofertas.id_municipio_origen ) as 'MUNICIPIO DE ORIGEN', ( SELECT d2.nombre FROM departamentos as d2 WHERE id=( SELECT m2.id_departamento FROM municipios as m2 WHERE id=ofertas.id_municipio_destino ) ) as 'DEPARTAMENTO DE DESTINO', ( SELECT m2.nombre FROM municipios as m2 WHERE id=ofertas.id_municipio_destino ) as 'MUNICIPIO DE DESTINO', ofertas.direccion_destino AS 'DIRECCIÓN DE DESTINO', ofertas.metodo_pago AS 'METODO DE PAGO', ofertas.metodo_envio AS 'METODO DE ENVIO', ofertas.valor_envio AS 'VALOR DEL ENVIO', ( SELECT u.cedula FROM users as u WHERE u.id=productos.id_user ) AS 'DOCUMENTO VENDEDOR', CONCAT_WS(' ',( SELECT u.primer_nombre FROM users as u WHERE u.id=productos.id_user ), ( SELECT u.segundo_nombre FROM users as u WHERE u.id=productos.id_user ), ( SELECT u.primer_apellido FROM users as u WHERE u.id=productos.id_user ), ( SELECT u.segundo_apellido FROM users as u WHERE u.id=productos.id_user )) AS 'VENDEDOR', ( SELECT u.telefono FROM users as u WHERE u.id=productos.id_user ) 'TELEFONO VENDEDOR' , ( SELECT IF(participantes.id=NULL, 'NO', 'SI') FROM participantes WHERE participantes.id_user=ofertas.id_user ) AS 'CLIENTE FEST', DATE_FORMAT(ofertas.created_at, '%Y-%m-%d') AS 'FECHA DE LA OFERTA'  FROM `ofertas` INNER JOIN users ON users.id=ofertas.id_user INNER JOIN productos ON productos.id=ofertas.id_producto INNER JOIN tipo_productos ON tipo_productos.id=productos.id_tipo_producto INNER JOIN unidades ON unidades.id=tipo_productos.id_unidad INNER JOIN stocks ON stocks.id=ofertas.id_stock");
        }

        if($this->dim=='ventasProveedores'){
            $reporte=DB::select("SELECT ofertas_proveedores.id, 
            users.cedula AS 'DOCUMENTO OFERTANTE', 
            CONCAT_WS(' ',users.primer_nombre, users.segundo_nombre, users.primer_apellido, users.segundo_apellido) AS 'OFERTANTE', 
            users.telefono AS 'TELEFONO OFERTANTE', 
            users.organizacion AS 'ORGANIZACIÓN',
            productos_proveedores.producto AS PRODUCTO, 
            categorias_proveedores.nombre AS 'CATEGORIA', 
            productos_proveedores.descripcion AS 'DESCRIPCIÓN', 
            productos_proveedores.unidad_venta AS 'UNIDAD DE VENTA', 
            ofertas_proveedores.cantidad AS 'CANTIDAD OFERTA', 
            ofertas_proveedores.valor_unitario AS 'VALOR UNITARIO OFERTA', 
            ( ofertas_proveedores.valor_unitario * ofertas_proveedores.cantidad ) AS 'VALOR TOTAL OFERTA', 
            ofertas_proveedores.estado AS ESTADO, 
            ofertas_proveedores.cantidad_venta AS 'CANTIDAD VENTA',
            ofertas_proveedores.valor_unitario_venta AS 'VALOR UNITARIO VENTA', 
            ( ofertas_proveedores.valor_unitario_venta * ofertas_proveedores.cantidad_venta ) AS 'VALOR TOTAL VENTA', 
            stocks_proveedores.descuento AS DESCUENTO, 
            ROUND( (ofertas_proveedores.valor_unitario_venta * ofertas_proveedores.cantidad_venta) - (ofertas_proveedores.valor_unitario_venta * ofertas_proveedores.cantidad_venta) * ( stocks_proveedores.descuento / 100 ) ) AS 'VALOR TOTAL VENTA CON DESCUENTO' ,
            ( SELECT d1.nombre FROM departamentos as d1 WHERE id=( SELECT m1.id_departamento FROM municipios as m1 WHERE id=ofertas_proveedores.id_municipio_origen ) ) as 'DEPARTAMENTO DE ORIGEN', 
            ( SELECT m1.nombre FROM municipios as m1 WHERE id=ofertas_proveedores.id_municipio_origen ) as 'MUNICIPIO DE ORIGEN', 
            ( SELECT d2.nombre FROM departamentos as d2 WHERE id=( SELECT m2.id_departamento FROM municipios as m2 WHERE id=ofertas_proveedores.id_municipio_destino ) ) as 'DEPARTAMENTO DE DESTINO', 
            ( SELECT m2.nombre FROM municipios as m2 WHERE id=ofertas_proveedores.id_municipio_destino ) as 'MUNICIPIO DE DESTINO', 
            ofertas_proveedores.direccion_destino AS 'DIRECCIÓN DE DESTINO', 
            ofertas_proveedores.metodo_pago AS 'METODO DE PAGO', 
            ofertas_proveedores.metodo_envio AS 'METODO DE ENVIO', 
            ofertas_proveedores.valor_envio AS 'VALOR DEL ENVIO', 
            ( SELECT u.cedula FROM users as u WHERE u.id=productos_proveedores.id_user ) AS 'DOCUMENTO VENDEDOR', 
            CONCAT_WS(' ',(SELECT u.primer_nombre FROM users as u WHERE u.id=productos_proveedores.id_user), (SELECT u.segundo_nombre FROM users as u WHERE u.id=productos_proveedores.id_user), (SELECT u.primer_apellido FROM users as u WHERE u.id=productos_proveedores.id_user), (SELECT u.segundo_apellido FROM users as u WHERE u.id=productos_proveedores.id_user)) AS 'NOMBRE DEL VENDEDOR', 
            ( SELECT u.nombre_almacen FROM users as u WHERE u.id=productos_proveedores.id_user ) AS 'NOMBRE DEL NEGOCIO', 
            ( SELECT u.telefono FROM users as u WHERE u.id=productos_proveedores.id_user ) 'TELEFONO VENDEDOR' , 
            DATE_FORMAT(ofertas_proveedores.created_at, '%Y-%m-%d') AS 'FECHA DE LA OFERTA'  FROM `ofertas_proveedores` INNER JOIN users ON users.id=ofertas_proveedores.id_user INNER JOIN productos_proveedores ON productos_proveedores.id=ofertas_proveedores.id_producto INNER JOIN categorias_proveedores ON categorias_proveedores.id=productos_proveedores.id_categoria INNER JOIN stocks_proveedores ON stocks_proveedores.id=ofertas_proveedores.id_stock");
        }

        if($this->dim=='ventasInclusion'){
            $reporte=DB::select("SELECT inclusionProductiva_ofertas.id, 
            users.cedula AS 'DOCUMENTO OFERTANTE', 
            CONCAT_WS(' ',users.primer_nombre, users.segundo_nombre, users.primer_apellido, users.segundo_apellido) AS 'OFERTANTE', 
            users.telefono AS 'TELEFONO OFERTANTE', 
            inclusionProductiva_tipo_productos.nombre AS PRODUCTO, 
            inclusionProductiva_productos.descripcion AS 'DESCRIPCIÓN', 
            unidades.nombre AS 'UNIDAD DE MEDIDA', 
            inclusionProductiva_ofertas.cantidad AS 'CANTIDAD OFERTA', 
            inclusionProductiva_ofertas.valor_unitario AS 'VALOR UNITARIO OFERTA', 
            ( inclusionProductiva_ofertas.valor_unitario * inclusionProductiva_ofertas.cantidad ) AS 'VALOR TOTAL OFERTA', 
            inclusionProductiva_ofertas.estado AS ESTADO, 
            inclusionProductiva_ofertas.cantidad_venta AS 'CANTIDAD VENTA', 
            inclusionProductiva_ofertas.valor_unitario_venta AS 'VALOR UNITARIO VENTA', 
            ( inclusionProductiva_ofertas.valor_unitario_venta * inclusionProductiva_ofertas.cantidad_venta ) AS 'VALOR TOTAL VENTA', 
            inclusionProductiva_stocks.descuento AS DESCUENTO, 
            ROUND( (inclusionProductiva_ofertas.valor_unitario_venta * inclusionProductiva_ofertas.cantidad_venta) - (inclusionProductiva_ofertas.valor_unitario_venta * inclusionProductiva_ofertas.cantidad_venta) * ( inclusionProductiva_stocks.descuento / 100 ) ) AS 'VALOR TOTAL VENTA CON DESCUENTO',
            ( SELECT d1.nombre FROM departamentos as d1 WHERE id=( SELECT m1.id_departamento FROM municipios as m1 WHERE id=inclusionProductiva_ofertas.id_municipio_origen ) ) as 'DEPARTAMENTO DE ORIGEN', 
            ( SELECT m1.nombre FROM municipios as m1 WHERE id=inclusionProductiva_ofertas.id_municipio_origen ) as 'MUNICIPIO DE ORIGEN', 
            ( SELECT d2.nombre FROM departamentos as d2 WHERE id=( SELECT m2.id_departamento FROM municipios as m2 WHERE id=inclusionProductiva_ofertas.id_municipio_destino ) ) as 'DEPARTAMENTO DE DESTINO', 
            ( SELECT m2.nombre FROM municipios as m2 WHERE id=inclusionProductiva_ofertas.id_municipio_destino ) as 'MUNICIPIO DE DESTINO', 
            inclusionProductiva_ofertas.direccion_destino AS 'DIRECCIÓN DE DESTINO', 
            inclusionProductiva_ofertas.metodo_pago AS 'METODO DE PAGO', 
            inclusionProductiva_ofertas.metodo_envio AS 'METODO DE ENVIO', 
            inclusionProductiva_ofertas.valor_envio AS 'VALOR DEL ENVIO', 
            ( SELECT u.cedula FROM users as u WHERE u.id=inclusionProductiva_productos.id_user ) AS 'DOCUMENTO VENDEDOR', 
            CONCAT_WS(' ',( SELECT u.primer_nombre FROM users as u WHERE u.id=inclusionProductiva_productos.id_user ), 
            ( SELECT u.segundo_nombre FROM users as u WHERE u.id=inclusionProductiva_productos.id_user ), 
            ( SELECT u.primer_apellido FROM users as u WHERE u.id=inclusionProductiva_productos.id_user ), 
            ( SELECT u.segundo_apellido FROM users as u WHERE u.id=inclusionProductiva_productos.id_user )) AS 'VENDEDOR', 
            ( SELECT u.telefono FROM users as u WHERE u.id=inclusionProductiva_productos.id_user ) 'TELEFONO VENDEDOR' , 
            ( SELECT IF(participantes.id=NULL, 'NO', 'SI') FROM participantes WHERE participantes.id_user=inclusionProductiva_ofertas.id_user ) AS 'CLIENTE FEST', 
            DATE_FORMAT(inclusionProductiva_ofertas.created_at, '%Y-%m-%d') AS 'FECHA DE LA OFERTA'  
            FROM `inclusionProductiva_ofertas` INNER JOIN users ON users.id=inclusionProductiva_ofertas.id_user INNER JOIN inclusionProductiva_productos ON inclusionProductiva_productos.id=inclusionProductiva_ofertas.id_producto INNER JOIN inclusionProductiva_tipo_productos ON inclusionProductiva_tipo_productos.id=inclusionProductiva_productos.id_tipo_producto INNER JOIN unidades ON unidades.id=inclusionProductiva_tipo_productos.id_unidad INNER JOIN inclusionProductiva_stocks ON inclusionProductiva_stocks.id=inclusionProductiva_ofertas.id_stock");
        }


        return json_decode(json_encode($reporte),true);
    }

    public function headings() : array
    {
        return $this->headings;
    }

}

